/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.appletbase;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.border.CompoundBorder;
import uibk.mtk.lang.MathPanel;
import uibk.mtk.lang.Options;
import uibk.mtk.lang.StandardOptions;
import uibk.mtk.swing.appletbase.AppletFrame;
import uibk.mtk.swing.appletbase.NavigationBar;
import uibk.mtk.swing.appletbase.ReportingLabel;
import uibk.mtk.swing.base.MPanel;

public class AppletBase
extends JApplet {
    protected boolean isStandalone = false;
    private static final int DIVIDERSIZE = 8;
    protected ReportingLabel labelreports = new ReportingLabel("Bereit");
    protected JSplitPane splitpanel;
    protected NavigationBar panelnav;
    private MPanel panelmain = new MPanel();
    private MPanel panelcontrol = new MPanel();
    MPanel base;
    Options options;
    private static float FRAME_SCALE_FACTOR = 0.75f;
    private static int FRAME_X_MIN = 650;
    private static int FRAME_Y_MIN = 550;

    public AppletBase() {
        this.options = new StandardOptions();
    }

    public AppletBase(Options options) {
        this.options = options == null ? new StandardOptions() : options;
    }

    public void init() {
        this.options.setLookAndFeel();
        this.initComponents();
        this.setOneTouchExpandable(true);
    }

    protected void initComponents() {
        this.base = new MPanel();
        this.base.setBackground(this.options.getBackgroundColor());
        this.base.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.labelreports.setBorder(BorderFactory.createLoweredBevelBorder());
        Font font = this.labelreports.getFont();
        this.labelreports.setFont(font.deriveFont(1));
        this.panelnav = new NavigationBar(this);
        this.panelnav.setReportingLabel(this.labelreports);
        if (this.isStandalone) {
            this.panelnav.enableInternetButtons(false);
        }
        this.panelmain = new MPanel();
        this.panelmain.setLayout(new BorderLayout(0, 0));
        this.panelmain.setBorder(BorderFactory.createLineBorder(Color.black));
        this.panelmain.setBackground(this.options.getBackgroundColor());
        this.panelcontrol = new MPanel();
        this.panelcontrol.setLayout(new BorderLayout(0, 0));
        this.panelcontrol.setBackground(this.options.getBackgroundColor());
        this.panelcontrol.setPreferredSize(new Dimension(140, 1000));
        this.splitpanel = new JSplitPane(1, this.panelmain, this.panelcontrol);
        this.splitpanel.setResizeWeight(0.8);
        this.splitpanel.setDividerSize(8);
        this.splitpanel.setContinuousLayout(false);
        this.splitpanel.setBackground(this.options.getBackgroundColor());
        this.splitpanel.setBorder(BorderFactory.createEmptyBorder());
        this.base.setLayout(new BorderLayout(5, 5));
        this.base.add((Component)this.panelnav, "North");
        this.base.add((Component)this.splitpanel, "Center");
        this.base.add((Component)this.labelreports, "South");
        this.getContentPane().add((Component)this.base, "Center");
    }

    public void setOneTouchExpandable(boolean bl) {
        this.splitpanel.setOneTouchExpandable(bl);
    }

    public void setDividerSize(int n) {
        this.splitpanel.setDividerSize(n);
    }

    public void setResizeWeight(double d) {
        this.splitpanel.setResizeWeight(d);
    }

    public String getAppletInfo() {
        return "(c) Institut fuer  Technische Mathematik, Geometrie und Bauinformatik, 2003-2004. Autor: Markus Unterweger";
    }

    protected void setMainPanel(JComponent jComponent) {
        this.panelmain.removeAll();
        this.panelmain.add(jComponent);
        this.setInfosMathPanel(jComponent);
    }

    private void setInfosMathPanel(JComponent jComponent) {
        Component[] componentArray;
        if (jComponent instanceof MathPanel) {
            componentArray = (Component[])jComponent;
            componentArray.setReporter(this.labelreports);
            componentArray.setOptions(this.options);
        }
        componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JComponent) {
                this.setInfosMathPanel((JComponent)componentArray[n]);
            }
            ++n;
        }
    }

    protected void setControlPanel(JComponent jComponent) {
        this.panelcontrol.removeAll();
        this.panelcontrol.add(jComponent);
    }

    public void setDividerLocation(int n) {
        this.splitpanel.setDividerLocation(n);
    }

    public void setDividerLocation(double d) {
        this.splitpanel.setDividerLocation(d);
    }

    public static void runmain(AppletBase appletBase, String string, float f) {
        appletBase.isStandalone = true;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        float f2 = 1.0f * (float)dimension.height / (float)dimension.width;
        int n = (int)((float)dimension.width * f);
        int n2 = (int)((float)n * f2);
        if (n < FRAME_X_MIN || n2 < FRAME_Y_MIN) {
            n = FRAME_X_MIN;
            n2 = FRAME_Y_MIN;
        }
        AppletFrame appletFrame = new AppletFrame(appletBase, n, n2, n, n2);
        appletFrame.setTitle(string);
    }

    public static void runmain(AppletBase appletBase, String string, float f, float f2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        appletBase.isStandalone = true;
        int n = (int)((float)dimension.width * f);
        int n2 = (int)((float)dimension.height * f2);
        AppletFrame appletFrame = new AppletFrame(appletBase, n, n2, n, n2);
        appletFrame.setTitle(string);
    }

    public static void runmain(AppletBase appletBase, String string) {
        AppletBase.runmain(appletBase, string, FRAME_SCALE_FACTOR);
    }
}

