/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.parser.realparser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uibk.mtk.parser.realparser.Token;
import uibk.mtk.parser.realparser.Variable;

class Scanner {
    private String inputstring;
    private String operatorChars;
    private Hashtable variables;
    Vector tokens = new Vector();
    int index = -1;

    public Scanner(String string, String string2, Hashtable hashtable) {
        this.inputstring = string;
        this.variables = hashtable;
        this.operatorChars = string2;
        int n = 0;
        while ((n = this.scanToken(n)) < this.inputstring.length()) {
        }
        this.addAsterisk();
    }

    private boolean isVariable(Token token) {
        boolean bl = false;
        if (this.variables.size() > 0) {
            String string = null;
            Enumeration enumeration = this.variables.elements();
            while (enumeration.hasMoreElements()) {
                string = ((Variable)enumeration.nextElement()).toString();
                if (!token.sval.equals(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void addAsterisk() {
        int n = 0;
        while (n < this.tokens.size() - 1) {
            Token token = (Token)this.tokens.elementAt(n);
            Token token2 = (Token)this.tokens.elementAt(n + 1);
            if (token.ttype == -3 && (token2.ttype == 40 || token2.ttype == -4)) {
                this.tokens.add(n + 1, new Token(42, 0.0, "*", 0, 1));
            }
            if (token.ttype == 41 && (token2.ttype == 40 || token2.ttype == -4 || token2.ttype == -3)) {
                this.tokens.add(n + 1, new Token(42, 0.0, "*", 0, 1));
            }
            if (this.isVariable(token) && token2.ttype == 40) {
                this.tokens.add(n + 1, new Token(42, 0.0, "*", 0, 1));
            }
            ++n;
        }
    }

    public String getInput() {
        return this.inputstring;
    }

    public String getOperatorChars() {
        return this.operatorChars;
    }

    public boolean isEmpty() {
        return this.tokens.size() == 0;
    }

    public boolean atStart() {
        return this.index <= 0;
    }

    public boolean atEnd() {
        return this.tokens.size() <= this.index;
    }

    public Token nextToken() {
        ++this.index;
        return this.getCurrentToken();
    }

    public Token previousToken() {
        --this.index;
        return this.getCurrentToken();
    }

    public Token getCurrentToken() {
        if (this.atEnd() || this.index < 0) {
            return new Token(-2, 0.0, this.inputstring, this.inputstring.length(), this.inputstring.length());
        }
        return (Token)this.tokens.elementAt(this.index);
    }

    private int scanToken(int n) {
        while (n < this.inputstring.length() && Character.isWhitespace(this.inputstring.charAt(n))) {
            ++n;
        }
        if (n == this.inputstring.length()) {
            return n;
        }
        if (this.operatorChars.indexOf(this.inputstring.charAt(n)) >= 0) {
            if (n + 1 < this.inputstring.length()) {
                String string = this.inputstring.substring(n, n + 2);
                int n2 = 0;
                if (string.equals("<=")) {
                    n2 = -5;
                } else if (string.equals(">=")) {
                    n2 = -7;
                } else if (string.equals("<>")) {
                    n2 = -6;
                }
                if (n2 != 0) {
                    this.tokens.addElement(new Token(n2, 0.0, this.inputstring, n, n + 2));
                    return n + 2;
                }
            }
            this.tokens.addElement(new Token(this.inputstring.charAt(n), 0.0, this.inputstring, n, n + 1));
            return n + 1;
        }
        if (Character.isLetter(this.inputstring.charAt(n))) {
            return this.scanSymbol(n);
        }
        if (Character.isDigit(this.inputstring.charAt(n)) || '.' == this.inputstring.charAt(n)) {
            return this.scanNumber(n);
        }
        this.tokens.addElement(this.makeErrorToken(n, n + 1));
        return n + 1;
    }

    private int scanSymbol(int n) {
        if (this.variables.size() > 0) {
            Variable variable = null;
            Enumeration enumeration = this.variables.elements();
            while (enumeration.hasMoreElements()) {
                variable = (Variable)enumeration.nextElement();
                String string = variable.toString();
                if (n + string.length() > this.inputstring.length() || !this.inputstring.substring(n, n + string.length()).equals(string)) continue;
                boolean bl = true;
                int n2 = 0;
                while (n2 < this.tokens.size()) {
                    if (((Token)this.tokens.elementAt((int)n2)).sval.equals(this.inputstring)) {
                        bl = false;
                    }
                    ++n2;
                }
                if (n + string.length() < this.inputstring.length() && (Character.isLetter(this.inputstring.charAt(n + string.length())) || Character.isDigit(this.inputstring.charAt(n + string.length())))) {
                    bl = false;
                }
                if (!bl) continue;
                this.tokens.addElement(new Token(-4, 0.0, this.inputstring, n, n + string.length()));
                return n + string.length();
            }
        }
        int n3 = n;
        while (n < this.inputstring.length() && (Character.isLetter(this.inputstring.charAt(n)) || Character.isDigit(this.inputstring.charAt(n)))) {
            ++n;
        }
        this.tokens.addElement(new Token(-4, 0.0, this.inputstring, n3, n));
        return n;
    }

    private int scanNumber(int n) {
        double d;
        int n2 = n;
        while (n < this.inputstring.length()) {
            if ('.' != this.inputstring.charAt(n) && !Character.isDigit(this.inputstring.charAt(n)) && this.inputstring.charAt(n) != 'E' && !this.inputstring.substring(n - 1, n + 1).equals("E-")) break;
            ++n;
        }
        String string = this.inputstring.substring(n2, n);
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.tokens.addElement(this.makeErrorToken(n2, n));
            return n;
        }
        this.tokens.addElement(new Token(-3, d, this.inputstring, n2, n));
        return n;
    }

    private Token makeErrorToken(int n, int n2) {
        return new Token(-1, 0.0, this.inputstring, n, n2);
    }
}

