/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.parser.realparser;

import java.util.Hashtable;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Scanner;
import uibk.mtk.parser.realparser.SyntaxException;
import uibk.mtk.parser.realparser.Token;
import uibk.mtk.parser.realparser.Variable;

public class Parser {
    private Hashtable variables = new Hashtable();
    Scanner tokenscanner = null;
    private Token token = null;
    String input;
    private String operatorChars = "*/+-^<>=,()!";
    private static final String[] PROCS1 = new String[]{"abs", "acos", "asin", "atan", "ceil", "cos", "exp", "floor", "log", "round", "sin", "sqrt", "tan", "faktorielle", "sign"};
    private static final int[] RATORS1 = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115};
    private static final String[] PROCS2 = new String[]{"atan2", "max", "min"};
    private static final int[] RATORS2 = new int[]{5, 6, 7};

    public Parser() {
        this.addStandardVariables();
    }

    public void clearVariables() {
        if (this.variables != null) {
            this.variables.clear();
            this.addStandardVariables();
        }
    }

    private void addStandardVariables() {
        Variable variable = new Variable("pi");
        variable.setValue(Math.PI);
        this.addVariable(variable);
    }

    public synchronized void addVariable(Variable variable) {
        Variable variable2 = (Variable)this.variables.get(variable.name);
        if (variable2 == null) {
            this.variables.put(variable.name, variable);
        }
    }

    private String trim(String string) {
        String string2 = "";
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                string2 = String.valueOf(string2) + string.charAt(n2);
            }
            ++n2;
        }
        return string2;
    }

    public Expr parseString(String string) throws SyntaxException {
        this.input = this.trim(string);
        this.tokenscanner = new Scanner(this.input, this.operatorChars, this.variables);
        return this.reparse();
    }

    private Expr reparse() throws SyntaxException {
        this.tokenscanner.index = -1;
        this.nextToken();
        Expr expr = this.parseExpr(0);
        expr.formula = this.input;
        if (this.token.ttype != -2) {
            throw this.error("Unvollst\u00e4ndiger Ausdruck", 0, null);
        }
        return expr;
    }

    private void nextToken() {
        this.token = this.tokenscanner.nextToken();
    }

    private Expr parseExpr(int n) throws SyntaxException {
        Expr expr = this.parseFactor();
        if (this.token.ttype == 33) {
            expr = Expr.makePost(114, expr);
            this.nextToken();
        }
        block13: while (true) {
            int n2;
            int n3;
            int n4;
            switch (this.token.ttype) {
                case 60: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 8;
                    break;
                }
                case -5: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 9;
                    break;
                }
                case 61: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 10;
                    break;
                }
                case -6: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 11;
                    break;
                }
                case -7: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 12;
                    break;
                }
                case 62: {
                    n4 = 20;
                    n3 = 21;
                    n2 = 13;
                    break;
                }
                case 43: {
                    n4 = 30;
                    n3 = 31;
                    n2 = 0;
                    break;
                }
                case 45: {
                    n4 = 30;
                    n3 = 31;
                    n2 = 1;
                    break;
                }
                case 47: {
                    n4 = 40;
                    n3 = 41;
                    n2 = 3;
                    break;
                }
                case 42: {
                    n4 = 40;
                    n3 = 41;
                    n2 = 2;
                    break;
                }
                case 94: {
                    n4 = 50;
                    n3 = 50;
                    n2 = 4;
                    break;
                }
                default: {
                    if (this.token.ttype == -4 && this.token.sval.equals("and")) {
                        n4 = 5;
                        n3 = 6;
                        n2 = 14;
                        break;
                    }
                    if (this.token.ttype != -4 || !this.token.sval.equals("or")) break block13;
                    n4 = 10;
                    n3 = 11;
                    n2 = 15;
                    break;
                }
            }
            if (n4 < n) break;
            this.nextToken();
            expr = Expr.makeApp2(n2, expr, this.parseExpr(n3));
        }
        return expr;
    }

    private Expr parseFactor() throws SyntaxException {
        switch (this.token.ttype) {
            case -3: {
                Expr expr = Expr.makeLiteral(this.token.nval);
                this.nextToken();
                return expr;
            }
            case -4: {
                int n = 0;
                while (n < PROCS1.length) {
                    if (PROCS1[n].equals(this.token.sval)) {
                        this.nextToken();
                        this.expect(40);
                        Expr expr = this.parseExpr(0);
                        this.expect(41);
                        return Expr.makeApp1(RATORS1[n], expr);
                    }
                    ++n;
                }
                n = 0;
                while (n < PROCS2.length) {
                    if (PROCS2[n].equals(this.token.sval)) {
                        this.nextToken();
                        this.expect(40);
                        Expr expr = this.parseExpr(0);
                        this.expect(44);
                        Expr expr2 = this.parseExpr(0);
                        this.expect(41);
                        return Expr.makeApp2(RATORS2[n], expr, expr2);
                    }
                    ++n;
                }
                if (this.token.sval.equals("if")) {
                    this.nextToken();
                    this.expect(40);
                    Expr expr = this.parseExpr(0);
                    this.expect(44);
                    Expr expr3 = this.parseExpr(0);
                    this.expect(44);
                    Expr expr4 = this.parseExpr(0);
                    this.expect(41);
                    return Expr.makeIfThenElse(expr, expr3, expr4);
                }
                Expr expr = (Expr)this.variables.get(this.token.sval);
                if (this.variables == null || this.variables.get(this.token.sval) == null) {
                    throw this.error("Unbekannte Variable: " + this.token.sval, 4, null);
                }
                this.nextToken();
                return expr;
            }
            case 40: {
                this.nextToken();
                Expr expr = this.parseExpr(0);
                this.expect(41);
                return expr;
            }
            case 45: {
                this.nextToken();
                return Expr.makeApp1(109, this.parseExpr(35));
            }
            case -2: {
                throw this.error("Faktor erwartet", 2, null);
            }
        }
        throw this.error("Faktor erwartet", 1, null);
    }

    private SyntaxException error(String string, int n, String string2) {
        return new SyntaxException(string, n, string2);
    }

    private void expect(int n) throws SyntaxException {
        if (this.token.ttype != n) {
            throw this.error("'" + (char)n + "' erwartet", 3, "" + (char)n);
        }
        this.nextToken();
    }
}

