/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.parsing;

import java.util.StringTokenizer;
import java.util.Vector;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.lang.InputException;
import uibk.mtk.math.Interval;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Parser;

public final class Misc {
    private static Parser parser = new Parser();

    private Misc() {
    }

    public static synchronized double parseConstantExpr(String string) throws InputException {
        Expr expr = parser.parseString(string);
        return expr.value();
    }

    public static synchronized Interval parseIntervall(String string, String string2, boolean bl) throws InputException {
        double d;
        double d2;
        if (string2 == null) {
            string2 = "";
        }
        if (string == null || string.equals("")) {
            throw new InputException(String.valueOf(string2) + ": kein Intervall definiert");
        }
        String string3 = string.trim();
        if (!string3.startsWith("[")) {
            throw new InputException(String.valueOf(string2) + ": Intervall muss mit  \"[\" beginnen");
        }
        if (!string3.endsWith("]")) {
            throw new InputException(String.valueOf(string2) + ": Intervall muss mit \"]\" enden");
        }
        int n = string3.indexOf(",");
        if (n < 0) {
            throw new InputException(String.valueOf(string2) + ": Intervall muss die Form [a,b] haben");
        }
        try {
            d2 = Misc.parseConstantExpr(string3.substring(1, n));
        }
        catch (InputException inputException) {
            throw new InputException(String.valueOf(string2) + ": untere Grenze des Intervalls ist keine reelle Zahl");
        }
        try {
            d = Misc.parseConstantExpr(string3.substring(n + 1, string.length() - 1));
        }
        catch (InputException inputException) {
            throw new InputException(String.valueOf(string2) + ": obere Grenze des Intervalls ist keine reelle Zahl");
        }
        if (bl) {
            if (d <= d2) {
                throw new InputException(String.valueOf(string2) + ": obere Grenze des Intervalls muss echt gr\u00f6\u00dfer wie untere Grenze sein");
            }
        } else if (d < d2) {
            throw new InputException(String.valueOf(string2) + ": obere Grenze des Intervalls muss gr\u00f6\u00dfer gleich wie untere Grenze sein");
        }
        Interval interval = new Interval(d2, d);
        return interval;
    }

    public static synchronized double[] parseInitalValues(String string, String string2) throws InputException {
        if (string == null || string.equals("")) {
            throw new InputException("Keine " + string2 + " definiert");
        }
        String string3 = string.trim();
        if (string3.charAt(0) == ',' || string3.charAt(string.length() - 1) == ',' || string3.indexOf(",,") >= 0) {
            throw new InputException("Die Werte m\u00fcssen in der Form 3,2,1,.. eingegeben werden");
        }
        String[] stringArray = Misc.split(string3, ",");
        if (stringArray == null || stringArray.length == 0) {
            throw new InputException("Fehler bei den Anfangswerten");
        }
        double[] dArray = new double[stringArray.length];
        int n = 0;
        while (n < dArray.length) {
            try {
                dArray[n] = Misc.parseConstantExpr(stringArray[n]);
            }
            catch (InputException inputException) {
                throw new InputException("Die " + string2 + " m\u00fcssen in der Form 3,2,1,.. eingegeben werden");
            }
            ++n;
        }
        return dArray;
    }

    public static synchronized double[] parseBracketInitalValues(String string, String string2) throws InputException {
        String string3 = string.trim();
        if (string3.charAt(0) != '(' || string3.charAt(string3.length() - 1) != ')') {
            try {
                double[] dArray = new double[]{Misc.parseConstantExpr(string3)};
                return dArray;
            }
            catch (InputException inputException) {
                throw new InputException(String.valueOf(string2) + " m\u00fcssen in der Form (3,2,...) eingegeben werden");
            }
        }
        string3 = string3.substring(1, string3.length() - 1);
        return Misc.parseInitalValues(string3, string2);
    }

    public static synchronized String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static synchronized double parseEps(String string, double d) throws InputException {
        return Misc.parseDoubleValue(string, "Genaugkeit", new Double(d), null, true);
    }

    public static synchronized double parseDoubleValue(String string, String string2, Double d, Double d2, Boolean bl) throws InputException {
        double d3 = 0.0;
        if (string == null || string.equals("")) {
            throw new InputException(String.valueOf(string2) + " nicht definiert");
        }
        try {
            d3 = Misc.parseConstantExpr(string);
        }
        catch (InputException inputException) {
            throw new InputException(String.valueOf(string2) + " ist keine reelle Zahl");
        }
        if (bl != null && bl.booleanValue() && d3 <= 0.0) {
            throw new InputException(String.valueOf(string2) + " muss positiv sein");
        }
        if (bl != null && !bl.booleanValue() && d3 >= 0.0) {
            throw new InputException(String.valueOf(string2) + " muss negativ sein");
        }
        if (d2 != null && d3 > d2) {
            throw new InputException(String.valueOf(string2) + " muss kleiner gleich " + d2 + " sein");
        }
        if (d != null && d3 < d) {
            throw new InputException(String.valueOf(string2) + " muss gr\u00f6\u00dfer gleich " + d + " sein");
        }
        return d3;
    }

    public static synchronized int parseIntegerValue(String string, String string2, Integer n, Integer n2) throws InputException {
        int n3 = 0;
        boolean bl = false;
        if (n != null && n >= 0) {
            bl = true;
        }
        if (string == null || string.equals("")) {
            throw new InputException(String.valueOf(string2) + " nicht definiert");
        }
        try {
            n3 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            String string3 = bl ? "nat\u00fcrliche" : "ganze";
            throw new InputException(String.valueOf(string2) + " ist keine " + string3 + " Zahl");
        }
        if (bl && n3 < 0) {
            throw new InputException(String.valueOf(string2) + " muss positiv sein");
        }
        if (n2 != null && n2 < 0 && n3 >= 0) {
            throw new InputException(String.valueOf(string2) + " muss negativ sein");
        }
        if (n2 != null && (double)n3 > n2.doubleValue()) {
            throw new InputException(String.valueOf(string2) + " muss kleiner gleich " + n2 + " sein");
        }
        if (n != null && (double)n3 < n.doubleValue()) {
            throw new InputException(String.valueOf(string2) + " muss gr\u00f6\u00dfer gleich " + n + " sein");
        }
        return n3;
    }

    public static synchronized CoordinateRect2D parseRectArea(String string, String string2, String string3, String string4) throws InputException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (string == null || string.equals("")) {
            throw new InputException("xmin ist nicht definiert");
        }
        if (string2 == null || string2.equals("")) {
            throw new InputException("xmax ist nicht definiert");
        }
        if (string3 == null || string3.equals("")) {
            throw new InputException("ymin ist nicht definiert");
        }
        if (string4 == null || string4.equals("")) {
            throw new InputException("ymax ist nicht definiert");
        }
        try {
            d = Misc.parseConstantExpr(string);
        }
        catch (InputException inputException) {
            throw new InputException("Fehler bei xmin:" + inputException.getMessage());
        }
        try {
            d2 = Misc.parseConstantExpr(string2);
        }
        catch (InputException inputException) {
            throw new InputException("Fehler bei xmax:" + inputException.getMessage());
        }
        try {
            d3 = Misc.parseConstantExpr(string3);
        }
        catch (InputException inputException) {
            throw new InputException("Fehler bei ymin:" + inputException.getMessage());
        }
        try {
            d4 = Misc.parseConstantExpr(string4);
        }
        catch (InputException inputException) {
            throw new InputException("Fehler bei ymax:" + inputException.getMessage());
        }
        if (d2 <= d) {
            throw new InputException("xmax muss gr\u00f6\u00dfer sein wie xmin");
        }
        if (d4 <= d3) {
            throw new InputException("ymax muss gr\u00f6\u00dfer sein wie ymin");
        }
        return new CoordinateRect2D(d, d2, d3, d4);
    }

    public static Punkt2D parsePunkt2D(String string, String string2) throws InputException {
        if (string == null || string.equals("")) {
            throw new InputException(String.valueOf(string2) + " nicht definiert");
        }
        try {
            double[] dArray = Misc.parseBracketInitalValues(string, "");
            return new Punkt2D(dArray[0], dArray[1]);
        }
        catch (InputException inputException) {
            throw new InputException("Der " + string2 + " muss in der Form (x,y) eingeben werden");
        }
    }

    public static int[] parseVarsIndices(String string, String string2, String string3) {
        int n;
        if (string3 == null) {
            return new int[0];
        }
        String[] stringArray = Misc.split(string3.trim(), string);
        if (stringArray == null || stringArray.length == 0) {
            return new int[0];
        }
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            n = -1;
            do {
                ++n;
                if ((n = stringArray[n2].indexOf(string2, n)) == -1) break;
                int n3 = Misc.scanNumber(n + string2.length(), stringArray[n2]);
                if (n3 == -1) continue;
                boolean bl = true;
                int n4 = 0;
                while (n4 < vector.size()) {
                    if ((Integer)vector.elementAt(n4) == n3) {
                        bl = false;
                    }
                    ++n4;
                }
                if (!bl) continue;
                vector.add(new Integer(n3));
            } while (n >= 0);
            ++n2;
        }
        int[] nArray = new int[vector.size()];
        n = 0;
        while (n < vector.size()) {
            nArray[n] = (Integer)vector.elementAt(n);
            ++n;
        }
        return nArray;
    }

    private static int scanNumber(int n, String string) {
        if (n >= string.length()) {
            return -1;
        }
        int n2 = n;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) break;
            ++n;
        }
        if (n2 == n || n > string.length()) {
            return -1;
        }
        String string2 = string.substring(n2, n);
        int n3 = Integer.valueOf(string2);
        return n3;
    }
}

