/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

import java.util.Hashtable;
import java.util.Vector;
import uibk.mtk.lang.ComputationException;
import uibk.mtk.lang.InputException;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Variable;

public class Sequence {
    Hashtable variables = new Hashtable();
    private double[] initial;
    Expr formula;
    int startindex;
    int endindex;
    int maxlengthsequence = 1000;
    public static final int RECURSIVE = 0;
    public static final int EXPLICIT = 1;
    private Vector rekindices;
    private int sequencedepth;

    public Sequence(Hashtable hashtable, Expr expr, Vector vector, int n) {
        this.variables = hashtable;
        this.formula = expr;
        this.sequencedepth = n;
        this.rekindices = vector;
    }

    public void setMaxSequenceLength(int n) {
        this.maxlengthsequence = n;
    }

    public void setInitialValues(double[] dArray) {
        this.initial = dArray;
    }

    public int getStartIndex() {
        return this.startindex;
    }

    public int getEndIndex() {
        return this.endindex;
    }

    private void check() throws Exception {
        if (this.variables == null || this.formula == null) {
            throw new InputException("Es ist keine Folge definiert");
        }
        if (this.endindex < 0) {
            throw new InputException("Der Endindex muss gr\u00f6\u00dfer gleich 0 sein");
        }
        if (this.startindex < 0) {
            throw new InputException("Der Startindex muss gr\u00f6\u00dfer gleich 0 sein");
        }
        if (this.endindex < this.startindex) {
            throw new Exception("Der Endindex muss gr\u00f6\u00dfer gleich dem Startindex sein");
        }
        if (this.getType() == 0) {
            if (this.initial == null) {
                throw new InputException("Ihre Formel ist rekursiv: Sie m\u00fcssen Startwerte angeben");
            }
            if (this.initial.length < this.sequencedepth && this.sequencedepth > 1) {
                throw new InputException("Zuwenige Startwerte definiert: Es werden " + String.valueOf(this.sequencedepth) + " Startwerte ben\u00f6tigt");
            }
            if (this.initial.length > this.sequencedepth) {
                if (this.sequencedepth > 1) {
                    throw new InputException("Zuviele Startwerte definiert: Es werden " + String.valueOf(this.sequencedepth) + " Startwerte ben\u00f6tigt");
                }
                throw new InputException("Zuviele Startwerte definiert: Es wird nur ein Startwert ben\u00f6tigt");
            }
        } else if (this.initial != null) {
            throw new InputException("Die Formel ist explizit: L\u00f6schen Sie die Startwerte");
        }
    }

    public String getFormula() {
        return this.formula.toString();
    }

    public double[] compute(double[] dArray, int n, int n2) throws Exception {
        int n3;
        int n4;
        this.initial = dArray;
        this.startindex = n;
        this.endindex = n2;
        this.check();
        double[] dArray2 = null;
        if (this.sequencedepth > 0) {
            if (n2 > this.maxlengthsequence) {
                throw new Exception("maximale Anzahl erlaubter Schritte ist " + this.maxlengthsequence);
            }
            if (n2 < this.sequencedepth) {
                dArray2 = new double[n2 + 1];
                int n5 = 0;
                while (n5 < n2 + 1) {
                    dArray2[n5] = this.initial[n5];
                    ++n5;
                }
                return dArray2;
            }
            n4 = this.sequencedepth;
            dArray2 = new double[n2 + 1];
            n3 = 0;
            while (n3 < n4) {
                dArray2[n3] = this.initial[n3];
                ++n3;
            }
            while (n4 < n2 + 1) {
                ((Variable)this.variables.get("n")).setValue(n4);
                n3 = 0;
                while (n3 < this.rekindices.size()) {
                    String string = "a(n-" + String.valueOf(this.rekindices.elementAt(n3)) + ")";
                    Variable variable = (Variable)this.variables.get(string);
                    Integer n6 = (Integer)this.rekindices.elementAt(n3);
                    double d = dArray2[n4 - n6];
                    variable.setValue(d);
                    ++n3;
                }
                dArray2[n4] = this.formula.value();
                ++n4;
            }
        } else {
            if (n2 - n > this.maxlengthsequence) {
                throw new Exception("maximale Anzahl erlaubter Schritte ist " + this.maxlengthsequence);
            }
            dArray2 = new double[n2 - n + 1];
            n4 = 0;
            while (n4 < n2 - n + 1) {
                ((Variable)this.variables.get("n")).setValue(n4 + n);
                dArray2[n4] = this.formula.value();
                ++n4;
            }
        }
        n4 = 0;
        while (n4 < dArray2.length) {
            if (Double.isInfinite(dArray2[n4])) {
                throw new ComputationException("Beim Berechnen der Folge gab es eine Division durch 0 oder einen \u00dcberlauf. \u00dcberpr\u00fcfen Sie die Formel und gegebenenfalls die Startwerte");
            }
            if (Double.isNaN(dArray2[n4])) {
                throw new ComputationException("Beim Berechnen der Folge gab es einen Ausdruck der Art 0/0  \n \u00dcberpr\u00fcfen Sie die Formel und die Startwerte");
            }
            ++n4;
        }
        if (this.sequencedepth > 0) {
            double[] dArray3 = new double[n2 - n + 1];
            n3 = n;
            while (n3 <= n2) {
                dArray3[n3 - n] = dArray2[n3];
                ++n3;
            }
            return dArray3;
        }
        return dArray2;
    }

    public int getType() {
        return this.sequencedepth > 0 ? 0 : 1;
    }
}

