/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

import uibk.mtk.geom.Punkt2D;

public final class MathUtil {
    private MathUtil() {
    }

    public static double max(double[] dArray) {
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (dArray[n] > d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            if (dArray[n] < d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static double interpolate(double d, double d2, double d3, double d4, double d5) {
        if (d2 - d <= 0.0) {
            return d3;
        }
        double d6 = (d2 - d5) / (d2 - d);
        double d7 = (d5 - d) / (d2 - d);
        return d6 * d3 + d7 * d4;
    }

    public static double norm1(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += Math.abs(dArray[n]);
            ++n;
        }
        return d;
    }

    public static double interpolate(Punkt2D punkt2D, Punkt2D punkt2D2, double d, double d2, Punkt2D punkt2D3) {
        double d3 = (punkt2D2.x - punkt2D.x) * (punkt2D2.x - punkt2D.x) + (punkt2D2.y - punkt2D.y) * (punkt2D2.y - punkt2D.y);
        if (d3 == 0.0) {
            return d;
        }
        double d4 = Math.sqrt(((punkt2D3.x - punkt2D.x) * (punkt2D3.x - punkt2D.x) + (punkt2D3.y - punkt2D.y) * (punkt2D3.y - punkt2D.y)) / d3);
        return d * (1.0 - d4) + d2 * d4;
    }

    public static double sign(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d < 0.0) {
            return -1.0;
        }
        if (d > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }
}

