/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.lang;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import uibk.mtk.lang.Clickable;
import uibk.mtk.lang.Dragable;
import uibk.mtk.lang.Drawable;
import uibk.mtk.lang.Highlightable;
import uibk.mtk.lang.Options;
import uibk.mtk.lang.Reporter;
import uibk.mtk.lang.ToolTipable;
import uibk.mtk.swing.base.MPanel;

public abstract class MathPanel
extends MPanel
implements ComponentListener {
    protected boolean repaintrequested = false;
    protected Highlightable highlighted = null;
    private HighlightListening highlightListener = new HighlightListening();
    private MyMouseDragListening mouseListenerDrag = new MyMouseDragListening();
    private MyMouseClickListening mouseListenerClicks = new MyMouseClickListening();
    private MyMouseMotionListening mouseMotionListener = new MyMouseMotionListening();
    boolean highlighting_enabled = false;
    private static final Color BACKGROUND = Color.white;
    Dragable dragged = null;
    boolean listenforclicks = false;
    boolean listenForDrags = false;
    protected BufferedImage framebuffer;
    protected Vector drawItems = new Vector();
    private Reporter reporter = null;
    protected Options options;
    Vector clickactions = new Vector();
    Vector dragactions = new Vector();
    Vector highlightactions = new Vector();

    public MathPanel() {
        this.setBackground(BACKGROUND);
        this.addComponentListener(this);
    }

    public void delete(Drawable drawable) {
        Iterator iterator = ((AbstractList)this.drawItems).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != drawable) continue;
            iterator.remove();
            this.requestRecompute();
            return;
        }
    }

    public void delete(Class clazz) {
        ListIterator listIterator = ((AbstractList)this.drawItems).listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            Class<?> clazz2 = e.getClass();
            while (clazz2 != null) {
                if (clazz2 == clazz) {
                    listIterator.remove();
                }
                clazz2 = clazz2.getSuperclass();
            }
        }
    }

    public ListIterator get(Class clazz) {
        ListIterator listIterator = ((AbstractList)this.drawItems).listIterator();
        Vector vector = new Vector();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            Class<?> clazz2 = e.getClass();
            while (clazz2 != null) {
                if (clazz2 == clazz) {
                    vector.add(e);
                }
                clazz2 = clazz2.getSuperclass();
            }
        }
        return ((AbstractList)vector).listIterator();
    }

    public void enableHighLighting(boolean bl) {
        if (this.highlighting_enabled == bl) {
            return;
        }
        this.highlighting_enabled = bl;
        if (this.highlighting_enabled) {
            this.addMouseMotionListener(this.highlightListener);
        } else {
            this.removeMouseMotionListener(this.highlightListener);
        }
    }

    public void setHighlightable(Highlightable highlightable) {
        this.highlighted = highlightable;
    }

    public Highlightable getHighLighted() {
        return this.highlighted;
    }

    public void requestRecompute() {
        this.repaintrequested = true;
    }

    public void repaint() {
        this.repaintrequested = true;
        super.repaint();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.drawItems.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.drawItems.elementAt(n2) instanceof ToolTipable && ((ToolTipable)this.drawItems.elementAt(n2)).isToolTipEnabled() && ((ToolTipable)this.drawItems.elementAt(n2)).tooltipcontains(mouseEvent.getX(), mouseEvent.getY())) {
                return ((ToolTipable)this.drawItems.elementAt(n2)).getToolTipText(mouseEvent);
            }
            ++n2;
        }
        return null;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void report(String string) {
        this.reporter.report(string);
    }

    public void reportError(Exception exception) {
        this.reportError(exception.getMessage());
    }

    public void reportError(String string, Exception exception) {
        this.reportError(String.valueOf(string) + ": " + exception.getMessage());
    }

    public void reportError(String string) {
        this.reporter.reportError(string);
    }

    public void reportSuccess(String string) {
        this.reporter.reportSuccess(string);
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public void add(Object object) {
        if (object == null || !(object instanceof Drawable)) {
            throw new IllegalArgumentException("");
        }
        if (!this.drawItems.contains(object)) {
            Drawable drawable = (Drawable)object;
            this.drawItems.addElement(drawable);
        }
    }

    public void addClickListener(ActionListener actionListener) {
        this.clickactions.add(actionListener);
    }

    public void addDragListener(ActionListener actionListener) {
        this.dragactions.add(actionListener);
    }

    public void addHighlightListener(ActionListener actionListener) {
        this.highlightactions.add(actionListener);
    }

    private void informClickListeners(Object object) {
        Iterator iterator = ((AbstractList)this.clickactions).iterator();
        while (iterator.hasNext()) {
            ActionEvent actionEvent = new ActionEvent(object, 0, "click");
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    private void informDragListeners(Object object) {
        Iterator iterator = ((AbstractList)this.dragactions).iterator();
        while (iterator.hasNext()) {
            ActionEvent actionEvent = new ActionEvent(object, 0, "drag");
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    private void informHighlightListeners(Object object) {
        Iterator iterator = ((AbstractList)this.highlightactions).iterator();
        while (iterator.hasNext()) {
            ActionEvent actionEvent = new ActionEvent(object, 0, "highlight");
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    public void setListenForClicks(boolean bl) {
        if (this.listenforclicks == bl) {
            return;
        }
        this.listenforclicks = bl;
        if (this.listenforclicks) {
            this.addMouseListener(this.mouseListenerClicks);
        } else {
            this.removeMouseListener(this.mouseListenerClicks);
        }
    }

    public void setListenForDragAndDrop(boolean bl) {
        if (bl == this.listenForDrags) {
            return;
        }
        this.listenForDrags = bl;
        if (bl) {
            this.addMouseListener(this.mouseListenerDrag);
            this.addMouseMotionListener(this.mouseMotionListener);
        } else {
            this.removeMouseListener(this.mouseListenerDrag);
            this.removeMouseMotionListener(this.mouseMotionListener);
        }
    }

    protected void preparebuffer() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.framebuffer != null && (this.framebuffer.getWidth() != n || this.framebuffer.getHeight() != n2)) {
            this.requestRecompute();
        }
        if (this.framebuffer == null || n > this.framebuffer.getWidth() || n2 > this.framebuffer.getHeight()) {
            this.framebuffer = (BufferedImage)this.createImage(n, n2);
        }
    }

    public synchronized void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.isVisible() || this.getWidth() < 100 || this.getHeight() < 100) {
            return;
        }
        this.preparebuffer();
        Graphics2D graphics2D = this.framebuffer.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.framebuffer.getWidth(), this.framebuffer.getHeight());
        this.drawDrawables(this.framebuffer, graphics2D);
        graphics.drawImage(this.framebuffer, 0, 0, null);
    }

    public void background(Drawable drawable) {
        Iterator iterator = ((AbstractList)this.drawItems).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != drawable) continue;
            iterator.remove();
            this.drawItems.add(0, drawable);
            this.requestRecompute();
            return;
        }
    }

    public void foreground(Drawable drawable) {
        Iterator iterator = ((AbstractList)this.drawItems).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != drawable) continue;
            iterator.remove();
            this.drawItems.add(drawable);
            this.requestRecompute();
            return;
        }
    }

    protected abstract void drawDrawables(BufferedImage var1, Graphics2D var2);

    protected class HighlightListening
    extends MouseMotionAdapter {
        protected HighlightListening() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Iterator iterator = ((AbstractList)MathPanel.this.drawItems).iterator();
            Highlightable highlightable = MathPanel.this.highlighted;
            MathPanel.this.highlighted = null;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Highlightable) || !((Highlightable)e).highlightcontains(mouseEvent.getX(), mouseEvent.getY())) continue;
                MathPanel.this.highlighted = (Highlightable)e;
                MathPanel.this.informHighlightListeners(e);
            }
            if (highlightable != MathPanel.this.highlighted) {
                MathPanel.this.repaint();
            }
        }
    }

    protected class MyMouseClickListening
    extends MouseAdapter {
        protected MyMouseClickListening() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = MathPanel.this.drawItems.size() - 1;
            while (n >= 0) {
                if (MathPanel.this.drawItems.elementAt(n) instanceof Clickable && ((Clickable)MathPanel.this.drawItems.elementAt(n)).clickcontains(mouseEvent.getX(), mouseEvent.getY())) {
                    ((Clickable)MathPanel.this.drawItems.elementAt(n)).click(mouseEvent);
                    MathPanel.this.informClickListeners(MathPanel.this.drawItems.elementAt(n));
                }
                --n;
            }
        }
    }

    protected class MyMouseDragListening
    extends MouseAdapter {
        protected MyMouseDragListening() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = MathPanel.this.drawItems.size() - 1;
            while (n >= 0) {
                if (MathPanel.this.drawItems.elementAt(n) instanceof Dragable && ((Dragable)MathPanel.this.drawItems.elementAt(n)).dragcontains(mouseEvent.getX(), mouseEvent.getY())) {
                    MathPanel.this.dragged = (Dragable)MathPanel.this.drawItems.elementAt(n);
                    MathPanel.this.drawItems.remove(n);
                    MathPanel.this.drawItems.add(MathPanel.this.dragged);
                }
                --n;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MathPanel.this.dragged = null;
        }
    }

    protected class MyMouseMotionListening
    extends MouseMotionAdapter {
        protected MyMouseMotionListening() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (MathPanel.this.dragged == null || !MathPanel.this.dragged.isDragEnabled()) {
                return;
            }
            MathPanel.this.dragged.drag(mouseEvent);
            MathPanel.this.informDragListeners(MathPanel.this.dragged);
            MathPanel.this.repaint();
        }
    }
}

