/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.geom;

import java.awt.Point;
import uibk.mtk.geom.Vector2D;
import uibk.mtk.math.MathUtil;

public class Punkt2D {
    public double x;
    public double y;

    public Punkt2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Punkt2D() {
    }

    public Punkt2D(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public Punkt2D(Punkt2D punkt2D) {
        this.x = punkt2D.x;
        this.y = punkt2D.y;
    }

    public Punkt2D add(Punkt2D punkt2D) {
        return new Punkt2D(this.x + punkt2D.x, this.y + punkt2D.y);
    }

    public Punkt2D sub(Punkt2D punkt2D) {
        return new Punkt2D(this.x - punkt2D.x, this.y - punkt2D.y);
    }

    public static Punkt2D inverse(Punkt2D punkt2D) {
        return new Punkt2D(-punkt2D.x, -punkt2D.y);
    }

    public void setLocation(Punkt2D punkt2D) {
        this.x = punkt2D.x;
        this.y = punkt2D.y;
    }

    public void setLocation(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Punkt2D scale(double d) {
        Punkt2D punkt2D = new Punkt2D();
        punkt2D.x = this.x * d;
        punkt2D.y = this.y * d;
        return punkt2D;
    }

    public void scaleself(double d) {
        this.x *= d;
        this.y *= d;
    }

    public double dotProd(Punkt2D punkt2D) {
        return this.x * punkt2D.x + this.y * punkt2D.y;
    }

    public double norm() {
        return MathUtil.hypot(this.x, this.y);
    }

    public double quadnorm() {
        return this.x * this.x + this.y * this.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public void normalize() {
        double d = this.norm();
        this.x /= d;
        this.y /= d;
    }

    public boolean isReal() {
        return !this.isNaN() && !this.isInfinite();
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.x) || Double.isInfinite(this.y);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.x);
    }

    public Vector2D toVector() {
        return new Vector2D(this.x, this.y);
    }

    public Object clone() {
        return new Punkt2D(this.x, this.y);
    }
}

