/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.geom;

import uibk.mtk.geom.Punkt2D;
import uibk.mtk.math.Rounder;

public class CoordinateRect2D
implements Cloneable {
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public static final int ROUND_X = 1;
    public static final int ROUND_Y = 2;
    public static final int ROUND_XY = 3;
    public static final int AREA_UPPERRIGHT = 1;
    public static final int AREA_UPPERLEFT = 2;
    public static final int AREA_LOWERLEFT = 4;
    public static final int AREA_LOWERRIGHT = 8;
    public static final int AREA_UPPER = 3;
    public static final int AREA_LOWER = 18;
    public static final int AREA_RIGHT = 9;
    public static final int AREA_LEFT = 6;
    public static final int AREA_ALL = 21;

    public CoordinateRect2D(double d, double d2, double d3, double d4) {
        if (d2 < d || d4 < d3) {
            throw new IllegalArgumentException("");
        }
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    public CoordinateRect2D() {
        this(-1.0, 1.0, -1.0, 1.0);
    }

    public boolean xcontains(double d) {
        return d <= this.xmax && d >= this.xmin;
    }

    public boolean ycontains(double d) {
        return d <= this.ymax && d >= this.ymin;
    }

    public boolean contains(CoordinateRect2D coordinateRect2D) {
        return !(coordinateRect2D.xmin < this.xmin || coordinateRect2D.ymin < this.ymin || coordinateRect2D.xmax > this.xmax) && !(coordinateRect2D.ymax > this.ymax);
    }

    public boolean contains(Punkt2D punkt2D) {
        return this.xcontains(punkt2D.x) && this.ycontains(punkt2D.y);
    }

    public boolean contains(double d, double d2) {
        return this.xcontains(d) && this.ycontains(d2);
    }

    public double getXRange() {
        return this.xmax - this.xmin;
    }

    public double getYRange() {
        return this.ymax - this.ymin;
    }

    public String toString() {
        return "[xmin=" + this.xmin + ", xmax=" + this.xmax + ", ymin=" + this.ymin + ", ymax=" + this.ymax + "]";
    }

    public Object clone() {
        return new CoordinateRect2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public CoordinateRect2D combine(CoordinateRect2D coordinateRect2D) {
        double d = this.xmin < coordinateRect2D.xmin ? this.xmin : coordinateRect2D.xmin;
        double d2 = this.xmax > coordinateRect2D.xmax ? this.xmax : coordinateRect2D.xmax;
        double d3 = this.ymin < coordinateRect2D.ymin ? this.ymin : coordinateRect2D.ymin;
        double d4 = this.ymax > coordinateRect2D.ymax ? this.ymax : coordinateRect2D.ymax;
        return new CoordinateRect2D(d, d2, d3, d4);
    }

    public void roundCoords(double d, int n) {
        double d2 = this.ymin;
        double d3 = this.ymax;
        double d4 = this.xmin;
        double d5 = this.xmax;
        double d6 = Math.abs((this.xmax - this.xmin) / 100.0 * d);
        double d7 = Math.abs((this.ymax - this.ymin) / 100.0 * d);
        if ((n & 2) == 2) {
            d3 = Rounder.getUpperRoundValue(this.ymax, d7);
            d2 = Rounder.getLowerRoundValue(this.ymin, d7);
        }
        if ((n & 1) == 1) {
            d5 = Rounder.getUpperRoundValue(this.xmax, d6);
            d4 = Rounder.getLowerRoundValue(this.xmin, d6);
        }
        if ((n & 2) == 2) {
            if (this.ymin > 0.0 && this.ymin - d7 < 0.0) {
                d2 = 0.0;
            }
            if (this.ymax < 0.0 && this.ymax + d7 > 0.0) {
                d3 = 0.0;
            }
        }
        if ((n & 1) == 1) {
            if (this.xmin > 0.0 && this.xmin - d6 < 0.0) {
                d4 = 0.0;
            }
            if (this.xmax < 0.0 && this.xmax + d6 > 0.0) {
                d5 = 0.0;
            }
        }
        this.ymin = d2;
        this.ymax = d3;
        this.xmin = d4;
        this.xmax = d5;
    }

    public int getArea() {
        if (this.ymin >= 0.0) {
            if (this.xmin >= 0.0) {
                return 1;
            }
            if (this.xmax <= 0.0) {
                return 2;
            }
            return 3;
        }
        if (this.ymax <= 0.0) {
            if (this.xmin >= 0.0) {
                return 8;
            }
            if (this.xmax <= 0.0) {
                return 4;
            }
            return 18;
        }
        if (this.xmax <= 0.0) {
            return 6;
        }
        if (this.xmin >= 0.0) {
            return 9;
        }
        return 21;
    }
}

