/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.lang.ToolTipable;

public class PointPlot2D
extends Graph2D
implements ToolTipable {
    protected Color linecolor;
    protected int pointradius;
    protected boolean tooltipenabled;
    protected Vector points = new Vector();
    boolean connectpoints = false;

    public void connectPoints(boolean bl) {
        this.connectpoints = bl;
    }

    public void setPointRadius(int n) {
        this.pointradius = n;
    }

    public void setLineColor(Color color) {
        this.linecolor = color;
    }

    public void setColor(Color color) {
        super.setColor(color);
        int n = 0;
        while (n < this.points.size()) {
            ((MathPoint2D)this.points.elementAt(n)).setColor(color);
            ++n;
        }
    }

    public boolean tooltipcontains(int n, int n2) {
        int n3 = this.points.size();
        int n4 = 0;
        while (n4 < n3) {
            MathPoint2D mathPoint2D = (MathPoint2D)this.points.elementAt(n4);
            if (mathPoint2D.tooltipcontains(n, n2)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.points.size();
        int n2 = 0;
        while (n2 < n) {
            MathPoint2D mathPoint2D = (MathPoint2D)this.points.elementAt(n2);
            if (mathPoint2D.tooltipcontains(mouseEvent.getX(), mouseEvent.getY())) {
                return "(" + mathPoint2D.getX() + "," + mathPoint2D.getY() + ")";
            }
            ++n2;
        }
        return null;
    }

    public void setToolTipText(String string) {
    }

    public boolean isToolTipEnabled() {
        return this.tooltipenabled;
    }

    public void enableToolTip(boolean bl) {
        this.tooltipenabled = bl;
    }

    public void setMathPanel2D(MathPanel2D mathPanel2D) {
        super.setMathPanel2D(mathPanel2D);
        int n = this.points.size();
        int n2 = 0;
        while (n2 < n) {
            ((Drawable2D)this.points.elementAt(n2)).setMathPanel2D(mathPanel2D);
            ++n2;
        }
    }

    public PointPlot2D() {
        this.linecolor = Color.blue;
        this.color = Color.red;
        this.pointradius = 2;
        this.stroke = new BasicStroke(1.0f);
        this.tooltipenabled = true;
    }

    public void setPoints(double[] dArray, double[] dArray2) {
        this.points.clear();
        int n = 0;
        while (n < dArray.length) {
            this.addMathPoint(dArray[n], dArray2[n]);
            ++n;
        }
        this.limitsdirty = true;
    }

    private void addMathPoint(double d, double d2) {
        MathPoint2D mathPoint2D = new MathPoint2D(d, d2);
        mathPoint2D.setMathPanel2D(this.panel);
        mathPoint2D.setRadius(this.pointradius);
        mathPoint2D.setColor(this.color);
        this.points.add(mathPoint2D);
    }

    public void draw(BufferedImage bufferedImage, Graphics2D graphics2D) {
        int n = this.points.size();
        int n2 = 0;
        while (n2 < n) {
            Drawable2D drawable2D = (Drawable2D)this.points.elementAt(n2);
            if (drawable2D.isVisible()) {
                if (n2 < n - 1) {
                    MathPoint2D mathPoint2D = (MathPoint2D)this.points.elementAt(n2);
                    MathPoint2D mathPoint2D2 = (MathPoint2D)this.points.elementAt(n2 + 1);
                    graphics2D.setColor(this.linecolor);
                    graphics2D.setStroke(this.stroke);
                    if (this.connectpoints) {
                        graphics2D.drawLine(this.scene2d.xToPixel(mathPoint2D.getX()), this.scene2d.yToPixel(mathPoint2D.getY()), this.scene2d.xToPixel(mathPoint2D2.getX()), this.scene2d.yToPixel(mathPoint2D2.getY()));
                    }
                }
                drawable2D.draw(bufferedImage, graphics2D);
            }
            ++n2;
        }
    }

    public void setPoints(Vector vector) {
        this.points = vector;
        this.limitsdirty = true;
    }

    public void addPoint(Punkt2D punkt2D) {
        this.addMathPoint(punkt2D.x, punkt2D.y);
        this.limitsdirty = true;
    }

    public void addPoint(double d, double d2) {
        this.points.add(new Punkt2D(d, d2));
        this.limitsdirty = true;
    }

    protected void recalcLimits() {
        this.limits = this.points != null && this.points.size() > 0 ? PointPlot2D.getLimits(this.points) : new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    }

    public static CoordinateRect2D getLimits(Vector vector) {
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) != null && ((MathPoint2D)vector.elementAt((int)n)).x > d) {
                d = ((MathPoint2D)vector.elementAt((int)n)).x;
            }
            ++n;
        }
        n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) != null && ((MathPoint2D)vector.elementAt((int)n)).y > d2) {
                d2 = ((MathPoint2D)vector.elementAt((int)n)).y;
            }
            ++n;
        }
        n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) != null && ((MathPoint2D)vector.elementAt((int)n)).x < d3) {
                d3 = ((MathPoint2D)vector.elementAt((int)n)).x;
            }
            ++n;
        }
        n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) != null && ((MathPoint2D)vector.elementAt((int)n)).y < d4) {
                d4 = ((MathPoint2D)vector.elementAt((int)n)).y;
            }
            ++n;
        }
        return new CoordinateRect2D(d3, d, d4, d2);
    }
}

