/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.lang.ToolTipable;

public class MathPoint2D
extends Drawable2D
implements ToolTipable {
    protected double x;
    protected double y;
    protected int radius = 1;
    protected boolean tooltipenabled = false;
    protected String toolTip = null;

    public MathPoint2D() {
    }

    public MathPoint2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setCoordinates(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setToolTipText(String string) {
        this.toolTip = string;
    }

    public void setCoordinates(Punkt2D punkt2D) {
        this.x = punkt2D.x;
        this.y = punkt2D.y;
    }

    public boolean isToolTipEnabled() {
        return this.tooltipenabled;
    }

    public void enableToolTip(boolean bl) {
        this.tooltipenabled = bl;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public boolean tooltipcontains(int n, int n2) {
        int n3;
        int n4 = this.scene2d.xToPixel(this.x);
        return (n - n4) * (n - n4) + (n2 - (n3 = this.scene2d.yToPixel(this.y))) * (n2 - n3) <= this.radius * this.radius;
    }

    public Punkt2D getPunkt2D() {
        return new Punkt2D(this.x, this.y);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.toolTip == null) {
            String string = "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + ")";
            return string;
        }
        return this.toolTip;
    }

    public void draw(BufferedImage bufferedImage, Graphics2D graphics2D) {
        graphics2D.setColor(this.color);
        graphics2D.fillOval(this.scene2d.xToPixel(this.x) - this.radius, this.scene2d.yToPixel(this.y) - this.radius, 2 * this.radius + 1, 2 * this.radius + 1);
    }
}

