/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.GeomUtil;
import uibk.mtk.geom.Punkt2D;

public class Graph2D
extends Drawable2D {
    protected Stroke stroke;
    protected Vector points = new Vector();
    protected CoordinateRect2D limits = new CoordinateRect2D();
    protected boolean limitsdirty = true;

    public Graph2D() {
        this.color = Color.red;
        this.stroke = new BasicStroke();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setPoints(Vector vector) {
        this.points = vector;
        this.limitsdirty = true;
    }

    public void addPoint(Punkt2D punkt2D) {
        this.points.add(punkt2D);
        this.limitsdirty = true;
    }

    public void addPoint(double d, double d2) {
        this.points.add(new Punkt2D(d, d2));
        this.limitsdirty = true;
    }

    protected void recalcLimits() {
        this.limits = this.points != null && this.points.size() > 0 ? GeomUtil.getLimits2D((Vector)this.points) : new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    }

    public void clearpoints() {
        this.points.clear();
        this.limits = new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    }

    public Vector getPoints() {
        return this.points;
    }

    public int getNumberPoints() {
        return this.points.size();
    }

    public CoordinateRect2D getLimits() {
        if (this.limitsdirty) {
            this.recalcLimits();
        }
        return (CoordinateRect2D)this.limits.clone();
    }

    public void draw(BufferedImage bufferedImage, Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(this.color);
        int n = 0;
        while (n < this.points.size() - 1) {
            Punkt2D punkt2D = (Punkt2D)this.points.elementAt(n);
            Punkt2D punkt2D2 = (Punkt2D)this.points.elementAt(n + 1);
            if (punkt2D != null && punkt2D2 != null) {
                int n2 = this.scene2d.xToPixel(punkt2D.x);
                int n3 = this.scene2d.yToPixel(punkt2D.y);
                int n4 = this.scene2d.xToPixel(punkt2D2.x);
                int n5 = this.scene2d.yToPixel(punkt2D2.y);
                graphics2D.setColor(this.color);
                graphics2D.drawLine(n2, n3, n4, n5);
            }
            ++n;
        }
        graphics2D.setStroke(stroke);
    }
}

