/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.base;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.math.Interval;

public class Scene2D {
    private int edge = 15;
    boolean ensurezerox = false;
    boolean ensurezeroy = false;
    double scalex = 1.0;
    double scaley = 1.0;
    boolean zoomforbidden = true;
    private Insets insets = new Insets(0, 0, 0, 0);
    private MathPanel2D mathpanel2d;
    private Insets requestedInsets = new Insets(0, 0, 0, 0);
    CoordinateRect2D limits = new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    CoordinateRect2D originallimits = new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    boolean equalize = false;
    boolean roundx = true;
    boolean roundy = true;
    double roundingpercent = 20.0;

    public double getScaleFactorX() {
        return this.scalex;
    }

    public double getScaleFactorY() {
        return this.scaley;
    }

    public void setScaleFactorX(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("");
        }
        if (d >= 1.0 || d < 1.0 && !this.zoomforbidden) {
            this.scalex = d;
        }
    }

    public void setScaleFactorY(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("");
        }
        if (d >= 1.0 || d < 1.0 && !this.zoomforbidden) {
            this.scaley = d;
        }
    }

    public Scene2D(MathPanel2D mathPanel2D) {
        this(mathPanel2D, new CoordinateRect2D());
    }

    public void reset() {
        this.setLimits(-1.0, 1.0, -1.0, 1.0);
    }

    public Rectangle getCoordinatePixelRectangle() {
        Rectangle rectangle = new Rectangle();
        rectangle.x = this.xToPixel(this.limits.xmin);
        rectangle.y = this.yToPixel(this.limits.ymax);
        rectangle.width = this.xToPixel(this.limits.xmax) - this.xToPixel(this.limits.xmin);
        rectangle.height = this.yToPixel(this.limits.ymin) - this.yToPixel(this.limits.ymax);
        return rectangle;
    }

    public Scene2D(MathPanel2D mathPanel2D, CoordinateRect2D coordinateRect2D) {
        this.mathpanel2d = mathPanel2D;
        this.setLimits(coordinateRect2D.xmin, coordinateRect2D.xmax, coordinateRect2D.ymin, coordinateRect2D.ymax);
    }

    boolean isScaleTooSmall() {
        return this.pixelToX(0) - this.pixelToX(1) == 0.0 || this.pixelToY(0) - this.pixelToY(1) == 0.0;
    }

    public void setXInterval(Interval interval) {
        this.setLimits(interval.a, interval.b, this.limits.ymin, this.limits.ymax);
    }

    public void setYInterval(Interval interval) {
        this.setLimits(this.limits.xmin, this.limits.xmax, interval.a, interval.b);
    }

    public void enableRoundX(boolean bl) {
        this.roundx = bl;
    }

    public void enableRound(boolean bl) {
        this.roundx = bl;
        this.roundy = bl;
    }

    public void enableRoundY(boolean bl) {
        this.roundy = bl;
    }

    public boolean isEnabledRoundX() {
        return this.roundx;
    }

    public boolean isEnabledRoundY() {
        return this.roundy;
    }

    public void setRoundingPercent(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.roundingpercent = d;
    }

    private void equalizeCoords() {
        int n = this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right;
        int n2 = this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom;
        double d = this.limits.xmin;
        double d2 = this.limits.xmax;
        double d3 = this.limits.ymin;
        double d4 = this.limits.ymax;
        double d5 = this.limits.getXRange() / (double)n;
        double d6 = this.limits.getYRange() / (double)n2;
        int n3 = this.getCoordinates().getArea();
        if (d5 < d6) {
            double d7 = d6 * (double)n - this.limits.getXRange();
            if (n3 == 1 || n3 == 9 || n3 == 8) {
                d2 = this.limits.xmax + d7;
            }
            if (n3 == 3 || n3 == 21 || n3 == 18) {
                d = this.limits.xmin - d7 / 2.0;
                d2 = this.limits.xmax + d7 / 2.0;
            }
            if (n3 == 2 || n3 == 6 || n3 == 4) {
                d = this.limits.xmin - d7;
            }
        } else {
            double d8 = d5 * (double)n2 - this.limits.getYRange();
            if (n3 == 1 || n3 == 3 || n3 == 2) {
                d4 = this.limits.ymax + d8;
            }
            if (n3 == 6 || n3 == 21 || n3 == 9) {
                d4 = this.limits.ymax + d8 / 2.0;
                d3 = this.limits.ymin - d8 / 2.0;
            }
            if (n3 == 8 || n3 == 18 || n3 == 4) {
                d3 = this.limits.ymin - d8;
            }
        }
        this.checkAndSetLimits(d, d2, d3, d4, this.limits);
    }

    public int getEdge() {
        return this.edge;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public double getXmax() {
        return this.limits.xmax;
    }

    public double getXmin() {
        return this.limits.xmin;
    }

    public double getXPixelScale() {
        return this.limits.getXRange() / (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right);
    }

    public double getYmax() {
        return this.limits.ymax;
    }

    public double getYmin() {
        return this.limits.ymin;
    }

    public double getYPixelScale() {
        return this.limits.getYRange() / (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom);
    }

    public double pixelToX(int n) {
        return this.limits.xmin + (double)(n - this.edge - this.insets.left) * (this.limits.xmax - this.limits.xmin) / (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right - 1);
    }

    public double pixelToY(int n) {
        return this.limits.ymax - (double)(n - this.edge - this.insets.top) * (this.limits.ymax - this.limits.ymin) / (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom - 1);
    }

    private void roundCoords() {
        int n = 0;
        if (this.roundx) {
            n = 1;
        }
        if (this.roundy) {
            n = 2;
        }
        if (this.roundx && this.roundy) {
            n = 3;
        }
        this.limits.roundCoords(this.roundingpercent, n);
    }

    public void setEdge(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("");
        }
        this.edge = n;
    }

    public void setLimits(CoordinateRect2D coordinateRect2D) {
        this.setLimits(coordinateRect2D.xmin, coordinateRect2D.xmax, coordinateRect2D.ymin, coordinateRect2D.ymax);
    }

    public void setLimits(double d, double d2, double d3, double d4) {
        this.checkAndSetLimits(d, d2, d3, d4, this.originallimits);
        this.scalex = 1.0;
        this.scaley = 1.0;
        this.prepareScene();
    }

    public void prepareScene() {
        this.limits = (CoordinateRect2D)this.originallimits.clone();
        if (this.ensurezerox) {
            this.ensureZeroX();
        }
        if (this.ensurezeroy) {
            this.ensureZeroY();
        }
        this.calcRescaledLimits();
        if (this.roundx || this.roundy) {
            this.roundCoords();
        }
        if (this.equalize) {
            this.equalizeCoords();
        }
    }

    public void ensureZero(boolean bl) {
        this.ensurezerox = bl;
        this.ensurezeroy = bl;
    }

    public void ensureLimits(CoordinateRect2D coordinateRect2D) {
        CoordinateRect2D coordinateRect2D2 = this.limits.combine(coordinateRect2D);
        this.setLimits(coordinateRect2D2.xmin, coordinateRect2D2.xmax, coordinateRect2D2.ymin, coordinateRect2D2.ymax);
    }

    private void ensureZeroY() {
        if (this.limits.ymin > 0.0) {
            this.checkAndSetLimits(this.limits.xmin, this.limits.xmax, 0.0, this.limits.ymax, this.limits);
            return;
        }
        if (this.limits.ymax < 0.0) {
            this.checkAndSetLimits(this.limits.xmin, this.limits.xmax, this.limits.ymin, 0.0, this.limits);
            return;
        }
    }

    private void ensureZeroX() {
        if (this.limits.xmin > 0.0) {
            this.checkAndSetLimits(0.0, this.limits.xmax, this.limits.ymin, this.limits.ymax, this.limits);
            return;
        }
        if (this.limits.xmax < 0.0) {
            this.checkAndSetLimits(this.limits.xmin, 0.0, this.limits.ymin, this.limits.ymax, this.limits);
            return;
        }
    }

    public void axesequal(boolean bl) {
        this.equalize = bl;
    }

    public boolean isAxesEqualEnabled() {
        return this.equalize;
    }

    private void checkAndSetLimits(double d, double d2, double d3, double d4, CoordinateRect2D coordinateRect2D) {
        if (d == d2) {
            coordinateRect2D.xmin = d - 1.0;
            coordinateRect2D.xmax = d + 1.0;
        } else {
            coordinateRect2D.xmin = d;
            coordinateRect2D.xmax = d2;
        }
        if (d3 == d4) {
            coordinateRect2D.ymin = d3 - 1.0;
            coordinateRect2D.ymax = d3 + 1.0;
        } else {
            coordinateRect2D.ymin = d3;
            coordinateRect2D.ymax = d4;
        }
    }

    public void ensureZeroX(boolean bl) {
        this.ensurezerox = bl;
    }

    public void ensureZeroY(boolean bl) {
        this.ensurezeroy = bl;
    }

    public void setPanel(MathPanel2D mathPanel2D) {
        this.mathpanel2d = mathPanel2D;
    }

    public String toString() {
        return this.limits.toString();
    }

    public int xToPixel(double d) {
        int n = this.edge + this.insets.left + (int)Math.round((d - this.limits.xmin) / (this.limits.xmax - this.limits.xmin) * (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right - 1));
        return n;
    }

    public int yToPixel(double d) {
        int n = this.edge + this.insets.top + (int)Math.round((this.limits.ymax - d) / (this.limits.ymax - this.limits.ymin) * (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom - 1));
        return n;
    }

    public Point project(Punkt2D punkt2D) {
        return new Point(this.xToPixel(punkt2D.x), this.yToPixel(punkt2D.y));
    }

    public Punkt2D projectdouble(Punkt2D punkt2D) {
        return new Punkt2D(this.xToPixel(punkt2D.x), this.yToPixel(punkt2D.y));
    }

    public CoordinateRect2D getCoordinates() {
        return (CoordinateRect2D)this.limits.clone();
    }

    public double getXRange() {
        return this.limits.getXRange();
    }

    public double getYRange() {
        return this.limits.getYRange();
    }

    boolean processRequests() {
        if (this.requestedInsets.left != 0 || this.requestedInsets.right != 0 || this.requestedInsets.top != 0 || this.requestedInsets.bottom != 0) {
            this.insets.left += this.requestedInsets.left;
            this.insets.right += this.requestedInsets.right;
            this.insets.top += this.requestedInsets.top;
            this.insets.bottom += this.requestedInsets.bottom;
            this.requestedInsets.left = 0;
            this.requestedInsets.right = 0;
            this.requestedInsets.top = 0;
            this.requestedInsets.bottom = 0;
            return true;
        }
        return false;
    }

    public void requestSpaceBottom(int n) {
        if (n >= this.mathpanel2d.getHeight() - this.edge && Math.abs(n - this.mathpanel2d.getHeight() + this.edge) > this.requestedInsets.bottom) {
            this.requestedInsets.bottom = Math.abs(n - this.mathpanel2d.getHeight() + this.edge);
        }
    }

    public void requestSpaceLeft(int n) {
        if (n <= this.edge && Math.abs(this.edge - n) > this.requestedInsets.left) {
            this.requestedInsets.left = Math.abs(this.edge - n);
        }
    }

    public void requestSpaceRight(int n) {
        if (n >= this.mathpanel2d.getWidth() - this.edge && Math.abs(n - this.mathpanel2d.getWidth() + this.edge) > this.requestedInsets.right) {
            this.requestedInsets.right = Math.abs(n - this.mathpanel2d.getWidth() + this.edge);
        }
    }

    public void requestSpaceTop(int n) {
        if (n <= this.edge && Math.abs(this.edge - n) > this.requestedInsets.top) {
            this.requestedInsets.top = Math.abs(this.edge - n);
        }
    }

    void resetInsets() {
        this.insets.bottom = 0;
        this.insets.top = 0;
        this.insets.left = 0;
        this.insets.right = 0;
        this.requestedInsets.bottom = 0;
        this.requestedInsets.top = 0;
        this.requestedInsets.left = 0;
        this.requestedInsets.right = 0;
    }

    private void calcRescaledLimits() {
        this.calcRescaledLimitsX(this.scalex);
        this.calcRescaledLimitsY(this.scaley);
    }

    private void calcRescaledLimitsX(double d) {
        double d2 = this.limits.xmin;
        double d3 = this.limits.xmax;
        double d4 = this.limits.ymin;
        double d5 = this.limits.ymax;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        int n = this.limits.getArea();
        if (n == 1 || n == 9 || n == 8) {
            d7 = d2 + this.getXRange() * d;
        }
        if (n == 3 || n == 21 || n == 18) {
            d7 = this.limits.xmax * d;
            d6 = this.limits.xmin * d;
        }
        if (n == 2 || n == 6 || n == 4) {
            d6 = d3 - this.getXRange() * d;
        }
        this.limits.xmin = d6;
        this.limits.xmax = d7;
        this.limits.ymin = d8;
        this.limits.ymax = d9;
    }

    private void calcRescaledLimitsY(double d) {
        double d2 = this.limits.xmin;
        double d3 = this.limits.xmax;
        double d4 = this.limits.ymin;
        double d5 = this.limits.ymax;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        int n = this.limits.getArea();
        if (n == 1 || n == 3 || n == 2) {
            d9 = d4 + this.getYRange() * d;
        }
        if (n == 6 || n == 21 || n == 9) {
            d9 = d5 * d;
            d8 = d4 * d;
        }
        if (n == 8 || n == 18 || n == 4) {
            d8 = d5 - this.getYRange() * d;
        }
        this.limits.xmin = d6;
        this.limits.xmax = d7;
        this.limits.ymin = d8;
        this.limits.ymax = d9;
    }

    public CoordinateRect2D getOriginalLimits() {
        return (CoordinateRect2D)this.originallimits.clone();
    }
}

