/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.axes2d;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Vector;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.axes2d.Axis;
import uibk.mtk.draw2d.axes2d.Tick;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.geom.Punkt2D;

class YAxis
extends Axis {
    YAxis(Axes2D axes2D) {
        super(axes2D);
    }

    void compute(Punkt2D punkt2D, Punkt2D punkt2D2, Punkt2D punkt2D3, int n, Graphics2D graphics2D, Scene2D scene2D) {
        int n2;
        if (this.style != 2) {
            Vector vector = this.axes.computeTickPositions(punkt2D.y, punkt2D2.y);
            if (vector != null && vector.size() > 0) {
                this.ticks = this.axes.createTicks(vector, n, scene2D.getYPixelScale() / 10.0, punkt2D.x, this.axes.formaty);
            }
            if (this.ticks != null) {
                n2 = 0;
                while (n2 < this.ticks.size()) {
                    ((Tick)this.ticks.elementAt(n2)).compute(graphics2D, scene2D);
                    ++n2;
                }
            }
        }
        int n3 = scene2D.xToPixel(punkt2D.x);
        n2 = scene2D.yToPixel(punkt2D.y);
        int n4 = scene2D.xToPixel(punkt2D2.x);
        int n5 = scene2D.yToPixel(punkt2D2.y);
        if (punkt2D3 != null && Math.abs(punkt2D.y - punkt2D3.y) > Math.abs(punkt2D2.y - punkt2D3.y)) {
            this.startPix.x = n4;
            this.startPix.y = n5;
            this.endPix.x = n3;
            this.endPix.y = n2;
            scene2D.requestSpaceBottom(this.endPix.y + Axis.ARROWLENGTH);
            if (this.axes.area == 21 || this.axes.area == 9 || this.axes.area == 6) {
                this.startPix.y -= Axis.ARROWLENGTH;
                scene2D.requestSpaceTop(this.startPix.y);
            }
        } else {
            this.startPix.x = n3;
            this.startPix.y = n2;
            this.endPix.x = n4;
            this.endPix.y = n5;
            scene2D.requestSpaceTop(this.endPix.y - Axis.ARROWLENGTH);
            if (this.axes.area == 21 || this.axes.area == 9 || this.axes.area == 6) {
                this.startPix.y += Axis.ARROWLENGTH;
                scene2D.requestSpaceBottom(this.startPix.y);
            }
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n6 = fontMetrics.getHeight();
        int n7 = fontMetrics.stringWidth(this.caption);
        this.captionpos.y = this.endPix.y + n6 / 4;
        this.captionpos.x = n == 0 ? this.endPix.x + 4 : this.endPix.x - n7 - 4;
        scene2D.requestSpaceRight(this.startPix.x + Axis.OFFSETWINGS);
        scene2D.requestSpaceLeft(this.startPix.x - Axis.OFFSETWINGS);
    }

    void draw(Graphics2D graphics2D, Scene2D scene2D) {
        graphics2D.setColor(this.axes.coloryaxes);
        if (this.axes.style == 1) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.axes.strokeyaxes);
            if (this.startPix.y > this.endPix.y) {
                this.drawArrow(graphics2D, this.endPix.x, this.endPix.y, 2);
            } else {
                this.drawArrow(graphics2D, this.endPix.x, this.endPix.y, 3);
            }
            graphics2D.drawLine(this.startPix.x, this.startPix.y, this.endPix.x, this.endPix.y);
            graphics2D.setStroke(stroke);
        }
        if (this.ticks != null && this.style != 2) {
            boolean bl = this.style == 1;
            int n = 0;
            while (n < this.ticks.size()) {
                ((Tick)this.ticks.elementAt(n)).draw(graphics2D, scene2D, bl);
                ++n;
            }
        }
        if (this.style == 1 && this.caption != null && !this.caption.equals("") && this.axes.style != 0) {
            graphics2D.drawString(this.caption, this.captionpos.x, this.captionpos.y);
        }
    }
}

