/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.axes2d;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Vector;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.axes2d.Axis;
import uibk.mtk.draw2d.axes2d.Tick;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.geom.Punkt2D;

class XAxis
extends Axis {
    XAxis(Axes2D axes2D) {
        super(axes2D);
    }

    void compute(Punkt2D punkt2D, Punkt2D punkt2D2, Punkt2D punkt2D3, int n, Graphics2D graphics2D, Scene2D scene2D) {
        int n2;
        if (this.style != 2) {
            Vector vector = this.axes.computeTickPositions(punkt2D.x, punkt2D2.x);
            if (vector != null && vector.size() > 0) {
                this.ticks = this.axes.createTicks(vector, n, scene2D.getXPixelScale() / 10.0, punkt2D.y, this.axes.formatx);
            }
            if (this.ticks != null) {
                n2 = 0;
                while (n2 < this.ticks.size()) {
                    ((Tick)this.ticks.elementAt(n2)).compute(graphics2D, scene2D);
                    ++n2;
                }
            }
        }
        int n3 = scene2D.xToPixel(punkt2D.x);
        n2 = scene2D.yToPixel(punkt2D.y);
        int n4 = scene2D.xToPixel(punkt2D2.x);
        int n5 = scene2D.yToPixel(punkt2D2.y);
        if (punkt2D3 != null && Math.abs(punkt2D.x - punkt2D3.x) > Math.abs(punkt2D2.x - punkt2D3.x)) {
            this.startPix.x = n4;
            this.startPix.y = n5;
            this.endPix.x = n3;
            this.endPix.y = n2;
            scene2D.requestSpaceLeft(this.endPix.x - Axis.ARROWLENGTH);
            if (this.axes.area == 3 || this.axes.area == 18 || this.axes.area == 21) {
                this.startPix.x += Axis.ARROWLENGTH;
                scene2D.requestSpaceRight(this.startPix.x);
            }
        } else {
            this.startPix.x = n3;
            this.startPix.y = n2;
            this.endPix.x = n4;
            this.endPix.y = n5;
            scene2D.requestSpaceRight(this.endPix.x + Axis.ARROWLENGTH);
            if (this.axes.area == 3 || this.axes.area == 18 || this.axes.area == 21) {
                this.startPix.x -= Axis.ARROWLENGTH;
                scene2D.requestSpaceLeft(this.startPix.x);
            }
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n6 = fontMetrics.stringWidth(this.caption);
        int n7 = fontMetrics.getHeight();
        this.captionpos.x = this.endPix.x - n6 / 2;
        this.captionpos.y = n == 3 ? this.endPix.y - 4 : this.endPix.y + 4 + n7 / 2;
        scene2D.requestSpaceTop(this.startPix.y - Axis.OFFSETWINGS);
        scene2D.requestSpaceBottom(this.startPix.y + Axis.OFFSETWINGS);
    }

    void draw(Graphics2D graphics2D, Scene2D scene2D) {
        graphics2D.setColor(this.axes.colorxaxes);
        if (this.axes.style == 1) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.axes.strokexaxes);
            if (this.startPix.x < this.endPix.x) {
                this.drawArrow(graphics2D, this.endPix.x, this.endPix.y, 0);
            } else {
                this.drawArrow(graphics2D, this.endPix.x, this.endPix.y, 1);
            }
            graphics2D.drawLine(this.startPix.x, this.startPix.y, this.endPix.x, this.endPix.y);
            graphics2D.setStroke(stroke);
        }
        if (this.ticks != null && this.style != 2) {
            boolean bl = this.style == 1;
            int n = 0;
            while (n < this.ticks.size()) {
                ((Tick)this.ticks.elementAt(n)).draw(graphics2D, scene2D, bl);
                ++n;
            }
        }
        if (this.style == 1 && this.caption != null && !this.caption.equals("") && this.axes.style != 0) {
            graphics2D.drawString(this.caption, this.captionpos.x, this.captionpos.y);
        }
    }
}

