/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.base.Scene2D;

class Tick {
    static final int TL_LEFT = 0;
    static final int TL_RIGHT = 1;
    static final int TL_TOP = 2;
    static final int TL_BOTTOM = 3;
    static final int LABEL_CENTER = 0;
    static final int LABEL_MOVEUP = 1;
    static final int LABEL_MOVEDOWN = 2;
    static final int LABEL_MOVERIGHT = 3;
    static final int LABEL_MOVELEFT = 4;
    boolean bigTick;
    Point2D.Double tickpos = new Point2D.Double();
    Point labelpos = new Point();
    int labelPos;
    int pos;
    String label;
    private static final int LENGTHBIGTICK = 6;
    private static final int LENGTHSMALLTICK = 3;
    Axes2D axes;
    private static final int SPACE = 10;

    Tick(int n, double d, double d2, boolean bl, String string, int n2, Axes2D axes2D) {
        this.pos = n;
        this.tickpos.x = d;
        this.tickpos.y = d2;
        this.bigTick = bl;
        this.labelPos = n2;
        this.label = string;
        this.axes = axes2D;
    }

    public void compute(Graphics2D graphics2D, Scene2D scene2D) {
        if (!this.bigTick) {
            return;
        }
        int n = scene2D.xToPixel(this.tickpos.x);
        int n2 = scene2D.yToPixel(this.tickpos.y);
        Font font = graphics2D.getFont();
        if (this.axes.font != null) {
            graphics2D.setFont(this.axes.font);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(this.label);
        int n4 = fontMetrics.getHeight();
        graphics2D.setFont(font);
        switch (this.pos) {
            case 0: {
                switch (this.labelPos) {
                    case 1: {
                        this.labelpos.y = n2 - 3;
                        break;
                    }
                    case 2: {
                        this.labelpos.y = n2 + n4 / 2 + 3;
                        break;
                    }
                    default: {
                        this.labelpos.y = n2 + n4 / 4;
                    }
                }
                this.labelpos.x = n - n3 - 10;
                scene2D.requestSpaceLeft(this.labelpos.x);
                break;
            }
            case 1: {
                this.labelpos.x = n + 10;
                this.labelpos.y = n2 + n4 / 4;
                scene2D.requestSpaceRight(this.labelpos.x + n3);
                break;
            }
            case 2: {
                this.labelpos.x = n - n3 / 2;
                this.labelpos.y = n2 - 10;
                scene2D.requestSpaceRight(this.labelpos.x + n3);
                scene2D.requestSpaceLeft(this.labelpos.x);
                scene2D.requestSpaceTop(this.labelpos.y);
                break;
            }
            case 3: {
                switch (this.labelPos) {
                    case 3: {
                        this.labelpos.x = n + 3;
                        break;
                    }
                    case 4: {
                        this.labelpos.x = n - n3 - 3;
                        break;
                    }
                    default: {
                        this.labelpos.x = n - n3 / 2;
                    }
                }
                this.labelpos.y = n2 + 10 + n4 / 2;
                scene2D.requestSpaceRight(this.labelpos.x + n3);
                scene2D.requestSpaceLeft(this.labelpos.x);
                scene2D.requestSpaceBottom(this.labelpos.y);
            }
        }
    }

    public void drawTick(Graphics2D graphics2D, Scene2D scene2D) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(0.5f));
        int n = this.bigTick ? 6 : 3;
        int n2 = scene2D.xToPixel(this.tickpos.x);
        int n3 = scene2D.yToPixel(this.tickpos.y);
        switch (this.pos) {
            case 0: {
                graphics2D.drawLine(n2 - n, n3, n2, n3);
                break;
            }
            case 1: {
                graphics2D.drawLine(n2 + n, n3, n2, n3);
                break;
            }
            case 2: {
                graphics2D.drawLine(n2, n3 - n, n2, n3);
                break;
            }
            case 3: {
                graphics2D.drawLine(n2, n3 + n, n2, n3);
                break;
            }
        }
        graphics2D.setStroke(stroke);
    }

    public void drawLabel(Graphics2D graphics2D) {
        if (!this.bigTick) {
            return;
        }
        Font font = graphics2D.getFont();
        if (this.axes.font != null) {
            graphics2D.setFont(this.axes.font);
        }
        if (this.label != null) {
            graphics2D.drawString(this.label, this.labelpos.x, this.labelpos.y);
        }
        graphics2D.setFont(font);
    }

    public void draw(Graphics2D graphics2D, Scene2D scene2D, boolean bl) {
        this.drawLabel(graphics2D);
        if (bl) {
            this.drawTick(graphics2D, scene2D);
        }
    }
}

