/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.UIManager;
import uibk.mtk.draw2d.axes2d.Tick;
import uibk.mtk.draw2d.axes2d.XAxis;
import uibk.mtk.draw2d.axes2d.YAxis;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.math.Rounder;
import uibk.mtk.text.Formatter;

public class Axes2D
extends Drawable2D
implements PrepaintComputable {
    int style = 1;
    public static final int MODE_BOX = 0;
    public static final int MODE_INTELLIGENT = 1;
    Color colorxaxes = Color.black;
    Color coloryaxes = Color.black;
    Stroke strokexaxes = new BasicStroke(1.5f);
    Stroke strokeyaxes = new BasicStroke(1.5f);
    DecimalFormat formatx;
    DecimalFormat formaty;
    public static final int AXES_STYLE_TICKS = 0;
    public static final int AXES_STYLE_TICKS_AND_LABELS = 1;
    public static final int AXES_STYLE_NOTICKS = 2;
    Font font;
    int area;
    private XAxis xaxis = new XAxis(this);
    private YAxis yaxis = new YAxis(this);
    private boolean visibilityXAxis = true;
    private boolean visibilityYAxis = true;
    private int numTicks;
    private Punkt2D pointAxesIntersect;
    private Formatter formatter = new Formatter();
    private Color edgecolor = UIManager.getColor("Panel.background");

    public void setDecimalFormatXAxes(DecimalFormat decimalFormat) {
        this.formatx = decimalFormat;
    }

    public void setDecimalFormatYAxes(DecimalFormat decimalFormat) {
        this.formaty = decimalFormat;
    }

    public Axes2D() {
        this.setStyleXAxis(1);
        this.setStyleYAxis(1);
        this.numTicks = 11;
    }

    public void setAxesStyle(int n) {
        this.style = n;
    }

    public int getAxesStyle() {
        return this.style;
    }

    public void setVisibilityXAxis(boolean bl) {
        this.visibilityXAxis = bl;
    }

    public void setVisibilityYAxis(boolean bl) {
        this.visibilityYAxis = bl;
    }

    public void setStyleXAxis(int n) {
        this.xaxis.setStyle(n);
    }

    public void setStyleYAxis(int n) {
        this.yaxis.setStyle(n);
    }

    public void setNumTicks(int n) {
        this.numTicks = n;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setEdgeColor(Color color) {
        this.edgecolor = color;
    }

    private void colorEdge(Graphics2D graphics2D) {
        graphics2D.setColor(this.edgecolor);
        Insets insets = this.scene2d.getInsets();
        int n = this.scene2d.getEdge();
        graphics2D.fillRect(0, 0, insets.left + n, this.panel.getHeight());
        graphics2D.fillRect(0, 0, this.panel.getWidth(), insets.top + n);
        graphics2D.fillRect(0, this.panel.getHeight() - insets.top - n, this.panel.getWidth(), insets.top + n);
        graphics2D.fillRect(this.panel.getWidth() - n - insets.right, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    public void draw(BufferedImage bufferedImage, Graphics2D graphics2D) {
        if (this.style == 0) {
            this.colorEdge(graphics2D);
        }
        if (this.xAxisVisible()) {
            this.xaxis.draw(graphics2D, this.scene2d);
        }
        if (this.yAxisVisible()) {
            this.yaxis.draw(graphics2D, this.scene2d);
        }
        if (this.style == 0) {
            graphics2D.setColor(Color.black);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.5f));
            int n = this.scene2d.xToPixel(this.scene2d.getXmin());
            int n2 = this.scene2d.xToPixel(this.scene2d.getXmax());
            int n3 = this.scene2d.yToPixel(this.scene2d.getYmin());
            int n4 = this.scene2d.yToPixel(this.scene2d.getYmax());
            graphics2D.drawLine(n, n3, n2, n3);
            graphics2D.drawLine(n, n3, n, n4);
            graphics2D.drawLine(n2, n3, n2, n4);
            graphics2D.drawLine(n, n4, n2, n4);
            graphics2D.setStroke(stroke);
        }
    }

    private boolean xAxisVisible() {
        return this.visibilityXAxis;
    }

    private boolean yAxisVisible() {
        return this.visibilityYAxis;
    }

    public void prepaintcompute() {
        double d = this.scene2d.getXmax();
        double d2 = this.scene2d.getXmin();
        double d3 = this.scene2d.getYmax();
        double d4 = this.scene2d.getYmin();
        this.pointAxesIntersect = new Punkt2D();
        this.area = this.scene2d.getCoordinates().getArea();
        Punkt2D punkt2D = new Punkt2D();
        Punkt2D punkt2D2 = new Punkt2D();
        Punkt2D punkt2D3 = new Punkt2D();
        Punkt2D punkt2D4 = new Punkt2D();
        int n = 0;
        int n2 = 0;
        if (this.style == 0) {
            this.area = 1;
        }
        switch (this.area) {
            case 1: {
                punkt2D.x = d2;
                punkt2D.y = d4;
                punkt2D2.x = d;
                punkt2D2.y = d4;
                punkt2D3.x = d2;
                punkt2D3.y = d4;
                punkt2D4.x = d2;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d2;
                this.pointAxesIntersect.y = d4;
                n = 3;
                n2 = 0;
                break;
            }
            case 9: {
                punkt2D.x = d2;
                punkt2D.y = 0.0;
                punkt2D2.x = d;
                punkt2D2.y = 0.0;
                punkt2D3.x = d2;
                punkt2D3.y = d4;
                punkt2D4.x = d2;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d2;
                this.pointAxesIntersect.y = 0.0;
                n = 3;
                n2 = 0;
                break;
            }
            case 8: {
                punkt2D.x = d2;
                punkt2D.y = d3;
                punkt2D2.x = d;
                punkt2D2.y = d3;
                punkt2D3.x = d2;
                punkt2D3.y = d4;
                punkt2D4.x = d2;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d2;
                this.pointAxesIntersect.y = d3;
                n = 3;
                n2 = 0;
                break;
            }
            case 3: {
                punkt2D.x = d2;
                punkt2D.y = d4;
                punkt2D2.x = d;
                punkt2D2.y = d4;
                punkt2D3.x = 0.0;
                punkt2D3.y = d4;
                punkt2D4.x = 0.0;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = d4;
                n = 3;
                n2 = 0;
                break;
            }
            case 21: {
                punkt2D.x = d2;
                punkt2D.y = 0.0;
                punkt2D2.x = d;
                punkt2D2.y = 0.0;
                punkt2D3.x = 0.0;
                punkt2D3.y = d4;
                punkt2D4.x = 0.0;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = 0.0;
                n = 3;
                n2 = 0;
                break;
            }
            case 6: {
                punkt2D.x = d2;
                punkt2D.y = 0.0;
                punkt2D2.x = d;
                punkt2D2.y = 0.0;
                punkt2D3.x = d;
                punkt2D3.y = d4;
                punkt2D4.x = d;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d;
                this.pointAxesIntersect.y = 0.0;
                n = 3;
                n2 = 1;
                break;
            }
            case 2: {
                punkt2D.x = d2;
                punkt2D.y = d4;
                punkt2D2.x = d;
                punkt2D2.y = d4;
                punkt2D3.x = d;
                punkt2D3.y = d4;
                punkt2D4.x = d;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d;
                this.pointAxesIntersect.y = d4;
                n = 3;
                n2 = 1;
                break;
            }
            case 4: {
                punkt2D.x = d2;
                punkt2D.y = d3;
                punkt2D2.x = d;
                punkt2D2.y = d3;
                punkt2D3.x = d;
                punkt2D3.y = d4;
                punkt2D4.x = d;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = d;
                this.pointAxesIntersect.y = d3;
                n = 2;
                n2 = 1;
                break;
            }
            case 18: {
                punkt2D.x = d2;
                punkt2D.y = d3;
                punkt2D2.x = d;
                punkt2D2.y = d3;
                punkt2D3.x = 0.0;
                punkt2D3.y = d4;
                punkt2D4.x = 0.0;
                punkt2D4.y = d3;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = d3;
                n = 2;
                n2 = 0;
                break;
            }
        }
        if (!this.xAxisVisible() || !this.yAxisVisible()) {
            this.pointAxesIntersect = null;
        }
        if (this.xAxisVisible()) {
            this.xaxis.compute(punkt2D, punkt2D2, this.pointAxesIntersect, n, (Graphics2D)this.panel.getGraphics(), this.scene2d);
        }
        if (this.yAxisVisible()) {
            this.yaxis.compute(punkt2D3, punkt2D4, this.pointAxesIntersect, n2, (Graphics2D)this.panel.getGraphics(), this.scene2d);
        }
    }

    public void setCaptionXAxis(String string) {
        this.xaxis.caption = string;
    }

    public void setCaptionYAxis(String string) {
        this.yaxis.caption = string;
    }

    Vector computeTickPositions(double d, double d2) {
        Vector<TickPosition> vector = new Vector<TickPosition>();
        switch (this.style) {
            case 1: {
                if (d2 > 0.0 && d < 0.0) {
                    boolean bl;
                    vector.add(new TickPosition(0.0, true));
                    double d3 = Math.abs(d2) >= Math.abs(d) ? Math.abs(d2) : Math.abs(d);
                    double d4 = Rounder.roundDownToLeadingDec(Math.abs(d3)) / (double)(this.numTicks - 1);
                    int n = 1;
                    double d5 = d4;
                    while (d5 <= d2 + d4 / 2.0) {
                        bl = n % 5 == 0;
                        vector.add(new TickPosition(d5, bl));
                        d5 = d4 * (double)(++n);
                    }
                    d5 = -d4;
                    n = 1;
                    while (d5 >= d - d4 / 2.0) {
                        bl = n % 5 == 0;
                        vector.add(new TickPosition(d5, bl));
                        d5 = -d4 * (double)(++n);
                    }
                } else if (d2 > 0.0 && d >= 0.0) {
                    vector.add(new TickPosition(d, true));
                    double d6 = Rounder.roundDownToLeadingDec(Math.abs(d2 - d)) / (double)(this.numTicks - 1);
                    double d7 = d + d6;
                    int n = 1;
                    while (d7 < d2 + d6 / 2.0) {
                        boolean bl = n % 5 == 0;
                        vector.add(new TickPosition(d7, bl));
                        d7 = d + d6 * (double)(++n);
                    }
                } else {
                    double d8 = Rounder.roundDownToLeadingDec(Math.abs(d2 - d)) / (double)(this.numTicks - 1);
                    vector.add(new TickPosition(d2, true));
                    double d9 = d2 - d8;
                    int n = 1;
                    while (d9 > d - d8 / 2.0) {
                        boolean bl = n % 5 == 0;
                        vector.add(new TickPosition(d9, bl));
                        d9 = d2 - d8 * (double)(++n);
                    }
                }
                break;
            }
            case 0: {
                vector.add(new TickPosition(d, true));
                double d10 = (d2 - d) / (double)(this.numTicks - 1);
                double d11 = d + d10;
                int n = 1;
                while (d11 < d2 - d10 / 2.0) {
                    boolean bl = n % 5 == 0;
                    vector.add(new TickPosition(d11, bl));
                    d11 = d + d10 * (double)(++n);
                }
                vector.add(new TickPosition(d2, true));
                break;
            }
        }
        return vector;
    }

    Vector createTicks(Vector vector, int n, double d, double d2, DecimalFormat decimalFormat) {
        Vector<Tick> vector2 = new Vector<Tick>();
        int n2 = 0;
        while (n2 < vector.size()) {
            Tick tick;
            double d3;
            TickPosition tickPosition = (TickPosition)vector.elementAt(n2);
            double d4 = n == 0 || n == 1 ? d2 : tickPosition.position;
            double d5 = d3 = n == 0 || n == 1 ? tickPosition.position : d2;
            if (tickPosition.maintick) {
                boolean bl = true;
                int n3 = 0;
                if (this.pointAxesIntersect != null) {
                    if (this.area == 21 && d3 == this.pointAxesIntersect.y && d4 == this.pointAxesIntersect.x) {
                        bl = false;
                    }
                    if ((n == 0 || n == 1) && d3 == this.pointAxesIntersect.y) {
                        n3 = this.moveLabel(n);
                    }
                    if ((n == 2 || n == 3) && d4 == this.pointAxesIntersect.x) {
                        n3 = this.moveLabel(n);
                    }
                }
                if (bl) {
                    String string = decimalFormat == null ? this.formatter.format(tickPosition.position, d) : decimalFormat.format(tickPosition.position);
                    tick = new Tick(n, d4, d3, tickPosition.maintick, string, n3, this);
                    vector2.add(tick);
                }
            } else {
                tick = new Tick(n, d4, d3, tickPosition.maintick, null, 0, this);
                vector2.add(tick);
            }
            ++n2;
        }
        return vector2;
    }

    private int moveLabel(int n) {
        if (this.area == 9 && n == 3) {
            return 3;
        }
        if (this.area == 8 && n == 3) {
            return 3;
        }
        if (this.area == 3 && n == 0) {
            return 1;
        }
        if (this.area == 18 && n == 0) {
            return 2;
        }
        if (this.area == 6 && n == 3) {
            return 4;
        }
        return 0;
    }

    private static class TickPosition {
        double position;
        boolean maintick;

        TickPosition(double d, boolean bl) {
            this.position = d;
            this.maintick = bl;
        }
    }
}

