/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.sequence;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import uibk.applets.sequence.AppletSequence;
import uibk.applets.sequence.PanelCommand;
import uibk.mtk.draw2d.objects.GraphSequence;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.math.Sequence;
import uibk.mtk.math.parsing.Misc;

public class InteractionControl
implements ActionListener {
    PanelCommand panelcommand;
    AppletSequence main;
    private boolean restart = true;
    private int countplots;
    private String input;

    public InteractionControl(AppletSequence appletSequence, PanelCommand panelCommand) {
        this.main = appletSequence;
        this.panelcommand = panelCommand;
    }

    private Sequence getSequence() {
        try {
            String string = this.panelcommand.textFormula.getText();
            return this.main.sequenceparser.parse(string, "n");
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError("Fehler in der Funktion", exception);
            return null;
        }
    }

    private double[] getInitials() {
        try {
            String string = this.panelcommand.textInitials.getText();
            return Misc.parseInitalValues(string, "Anfangswerte");
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError("Fehler bei den Anfangswerten", exception);
            return null;
        }
    }

    private int[] getStartEnd() {
        try {
            int n = this.panelcommand.textSequenceStart.getValue();
            int n2 = this.panelcommand.textSequenceEnd.getValue();
            return new int[]{n, n2};
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError("Fehler bei den Indizes", exception);
            return null;
        }
    }

    private void clear() {
        this.main.graphfolgen.clear();
        this.main.axes.setVisible(false);
        this.restart = true;
        this.countplots = 0;
        this.main.mathpanel2d.repaint();
        this.main.mathpanel2d.report("Zeichenbereich gel\u00f6scht");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("clear")) {
            this.clear();
        }
        if (actionEvent.getActionCommand().equals("compute")) {
            this.compute();
        }
    }

    private String getInputString() {
        String string = this.panelcommand.textSequenceStart.getText();
        String string2 = this.panelcommand.textFormula.getText();
        String string3 = this.panelcommand.textSequenceEnd.getText();
        String string4 = this.panelcommand.textInitials.getText();
        return (String.valueOf(string) + string2 + string3 + string4).trim();
    }

    private void compute() {
        double[] dArray;
        if (!this.panelcommand.optsingleplot.isSelected() && !this.restart && this.input != null && this.input.equals(this.getInputString())) {
            return;
        }
        this.input = null;
        Sequence sequence = this.getSequence();
        int[] nArray = this.getStartEnd();
        if (sequence == null || nArray == null) {
            return;
        }
        if (sequence.getType() == 0) {
            dArray = this.getInitials();
            if (dArray == null) {
                return;
            }
        } else {
            if (!this.panelcommand.textInitials.getText().equals("")) {
                this.main.mathpanel2d.reportError("Die Formel ist explizit: L\u00f6schen Sie die Startwerte");
                return;
            }
            dArray = null;
        }
        this.calcplot(sequence, dArray, nArray[0], nArray[1]);
    }

    private void calcplot(Sequence sequence, double[] dArray, int n, int n2) {
        double[] dArray2 = null;
        try {
            dArray2 = sequence.compute(dArray, n, n2);
            if (this.panelcommand.optsingleplot.isSelected()) {
                this.countplots = 0;
                this.restart = true;
                this.main.graphfolgen.clear();
            }
            GraphSequence graphSequence = new GraphSequence();
            graphSequence.setFormula(sequence.getFormula());
            this.main.graphfolgen.addGraph(graphSequence);
            graphSequence.setSequence(dArray2, n, n2);
            graphSequence.setLineColor(AppletSequence.LINECOLORS[this.countplots % 6]);
            graphSequence.setColor(AppletSequence.POINTCOLORS[this.countplots % 6]);
            this.main.axes.setVisible(true);
            CoordinateRect2D coordinateRect2D = graphSequence.getLimits();
            if (this.restart) {
                this.main.mathpanel2d.getScene2d().setLimits(coordinateRect2D);
            } else {
                this.main.mathpanel2d.getScene2d().ensureLimits(coordinateRect2D);
            }
            this.restart = false;
            this.main.mathpanel2d.reportSuccess("Folge " + sequence.getFormula() + " gezeichnet");
            this.input = this.getInputString();
            ++this.countplots;
        }
        catch (Exception exception) {
            this.main.mathpanel2d.reportError(exception);
        }
        this.main.mathpanel2d.repaint();
    }
}

