/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.parsing;

import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Parser;
import uibk.mtk.parser.realparser.Variable;

public final class ODEParser {
    private static final String BUNDLE_NAME = "uibk.mtk.math.parsing.messages";
    static Parser parser = new Parser();

    private ODEParser() {
    }

    public static synchronized ParsedFunction parse(String[] strFunction, char[] chrVariables, boolean autonom) throws Exception {
        if (strFunction == null) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "ODEParser.0"));
        }
        if (!autonom) {
            String[] strTemp = new String[strFunction.length + 1];
            strTemp[0] = "1";
            int i = 1;
            while (i < strTemp.length) {
                strTemp[i] = strFunction[i - 1];
                ++i;
            }
            strFunction = strTemp;
        }
        parser.clearVariables();
        int n = strFunction.length;
        Variable[] variables = new Variable[n];
        Expr[] functions = new Expr[n];
        if (n != chrVariables.length) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "ODEParser.2"));
        }
        int i = 0;
        while (i < chrVariables.length) {
            Variable var;
            variables[i] = var = new Variable(String.valueOf(chrVariables[i]));
            parser.addVariable(var);
            ++i;
        }
        i = 0;
        while (i < strFunction.length) {
            functions[i] = parser.parseString(strFunction[i]);
            ++i;
        }
        return new ParsedFunction(variables, functions);
    }

    public static synchronized InitialCondition parseInitialCondition(String strInitialCondition, char var, boolean autonom) throws Exception {
        double start;
        InitialCondition ic = new InitialCondition();
        String[] strTemp = Misc.split(strInitialCondition.trim(), "=");
        if (strTemp.length != 2) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "ODEParser.4"));
        }
        String left = strTemp[0];
        if (left.charAt(0) != var || left.charAt(1) != '(' || left.charAt(left.length() - 1) != ')') {
            throw new InputException(Messages.getString(BUNDLE_NAME, "ODEParser.5"));
        }
        try {
            start = Misc.parseConstantExpr(left.substring(2, left.length() - 1));
        }
        catch (Exception ex) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "ODEParser.6"));
        }
        try {
            if (autonom) {
                ic.x0 = Misc.parseBracketInitalValues(strTemp[1], Messages.getString(BUNDLE_NAME, "ODEParser.7"));
            } else {
                double[] temp = Misc.parseBracketInitalValues(strTemp[1], Messages.getString(BUNDLE_NAME, "ODEParser.8"));
                ic.x0 = new double[temp.length + 1];
                ic.x0[0] = start;
                int i = 1;
                while (i < ic.x0.length) {
                    ic.x0[i] = temp[i - 1];
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "ODEParser.9"));
        }
        return ic;
    }

    public static class InitialCondition {
        public double t0;
        public double[] x0;
    }
}

