/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

import java.util.Vector;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.Settings;
import uibk.mtk.math.Interval;
import uibk.mtk.math.MathUtil;
import uibk.mtk.math.functions.Function;

public class ODESolver {
    Function f;
    ODEReport report = new ODEReport();
    public static final int INTEGRATE_BOTH = 0;
    public static final int INTEGRATE_FORWARD = 1;
    public static final int INTEGRATE_BACKWARD = 2;
    int integrationDirection = 0;
    int maxsteps = 2000;
    boolean denseoutput = true;
    private static final int NUMBEROFSTEPS = 7;
    double[] initials;
    double tol = 1.0E-7;
    double a;
    double b;
    double start = 0.0;
    double hmin = Settings.getMachinePrecision() * 100.0;
    double hstart = 0.1;
    double hdense = 0.01;
    int n = 0;
    boolean stepsizecontrol = true;
    private static final int DENSEOUTPUTSTEPS = 1000;
    private boolean onlyendsolution = false;
    double t;
    double[] y;
    double[] yerr;
    double esterror;
    double[][] steps;
    double h;
    double theta;
    static final String BUNDLE_NAME = "uibk.mtk.math.messages";

    public boolean integrationSuccess() {
        boolean successbackward;
        boolean successforward;
        boolean bl = this.report.integratedforward ? !(this.report.toosmallstepforward || this.report.toomanystepsforward || this.report.singularityforward) : (successforward = true);
        boolean bl2 = this.report.integratedbackward ? !(this.report.toosmallstepbackward || this.report.toomanystepsbackward || this.report.singularitybackward) : (successbackward = true);
        return successforward && successbackward;
    }

    public double getTOL() {
        return this.tol;
    }

    public double getInitialStepsize() {
        return this.hstart;
    }

    public void setInitialStepsize(double h) {
        this.hstart = h;
    }

    public ODEReport getReport() {
        return this.report;
    }

    public boolean isStepSizeControlEnabled() {
        return this.stepsizecontrol;
    }

    public boolean isDenseOutputEnabled() {
        return this.denseoutput;
    }

    public int getMaxSteps() {
        return this.maxsteps;
    }

    public void setHMin(double hmin) {
        this.hmin = Math.abs(hmin);
    }

    public void enableDenseOutput(boolean enable) {
        this.denseoutput = enable;
    }

    public void enabelStepSizeControl(boolean enable) {
        this.stepsizecontrol = enable;
    }

    public ODESolver(Function f) {
        this.setDGL(f);
    }

    public ODESolver() {
    }

    public void setMaxSteps(int maxsteps) {
        this.maxsteps = maxsteps;
    }

    public void setIntegrationInvervall(Interval interval) {
        this.a = interval.a;
        this.b = interval.b;
    }

    public void setInitialCondition(double t0, double[] y0) {
        this.start = t0;
        this.initials = y0;
    }

    public void setTOL(double eps) {
        this.tol = eps <= 0.0 ? 0.001 : eps;
    }

    public void setDGL(Function function) {
        this.f = function;
        this.n = function.getNumberFunctions();
    }

    public void setHDense(double hdense) {
        this.hdense = Math.abs(hdense);
    }

    private double newStepSize() {
        double a = 6.0;
        double b = 0.2;
        int p = 5;
        if (this.stepsizecontrol) {
            return Math.abs(this.h) * Math.min(a, Math.max(b, 0.9 * Math.pow(this.tol / this.esterror, 1.0 / (double)p)));
        }
        return Math.abs(this.h);
    }

    double calcerr(double[] y0, double[] y1, double[] yerr) {
        double delta = 0.02;
        double gamma = 1.0;
        double err = 0.0;
        int i = 0;
        while (i < this.n) {
            double scale = delta + gamma * Math.max(Math.abs(y0[i]), Math.abs(y1[i]));
            err += yerr[i] / scale * (yerr[i] / scale);
            ++i;
        }
        err /= (double)this.n;
        err = Math.sqrt(err);
        return err;
    }

    public double[] solve(double b, double[] initials) throws Exception {
        this.onlyendsolution = true;
        boolean savedenseoutput = this.denseoutput;
        this.denseoutput = false;
        this.setInitialCondition(0.0, initials);
        this.start = 0.0;
        if (b == 0.0) {
            return initials;
        }
        if (b > 0.0) {
            this.b = b;
            this.a = 0.0;
        } else {
            this.a = b;
            b = 0.0;
        }
        Vector sol = this.solve(null);
        this.onlyendsolution = false;
        this.denseoutput = savedenseoutput;
        return (double[])sol.elementAt(sol.size() - 1);
    }

    private void init() throws Exception {
        this.n = this.f.getNumberFunctions();
        if (this.f == null) {
            throw new Exception(Messages.getString(BUNDLE_NAME, "ODESolver.0"));
        }
        if (this.initials == null) {
            throw new Exception(Messages.getString(BUNDLE_NAME, "ODESolver.1"));
        }
        if (MathUtil.norm1(this.derivs(this.initials)) == 0.0) {
            throw new Exception(Messages.getString(BUNDLE_NAME, "ODESolver.2"));
        }
        this.hdense = (this.b - this.a) / 1000.0;
        this.y = this.initials;
        this.yerr = new double[this.n];
        this.t = this.start;
        this.steps = new double[7][0];
        this.report = new ODEReport();
        this.report.minstepsizebackward = Double.MAX_VALUE;
        this.report.maxstepsizebackward = Double.MIN_VALUE;
        this.report.minstepsizeforward = Double.MAX_VALUE;
        this.report.maxstepsizeforward = Double.MIN_VALUE;
        if (this.t < this.b) {
            this.report.integratedforward = true;
        }
        if (this.t > this.a) {
            this.report.integratedbackward = true;
        }
    }

    public Vector solve(Output output) throws Exception {
        double[] denseY;
        this.init();
        int count = 0;
        double[] ynew = null;
        this.h = Math.min(this.hstart, this.b - this.t);
        Vector<double[]> solforward = new Vector<double[]>();
        Vector<double[]> solbackward = new Vector<double[]>();
        Vector<Object> sol = new Vector<Object>();
        boolean accepted = false;
        if (this.integrationDirection == 0 || this.integrationDirection == 1) {
            this.report.timeforward = this.b;
        }
        while (this.t <= this.b) {
            if (this.h < this.hmin) {
                this.report.toosmallstepforward = true;
                this.report.timeforward = this.t;
                break;
            }
            if (count >= this.maxsteps) {
                this.report.toomanystepsforward = true;
                this.report.timeforward = this.t;
                break;
            }
            try {
                ynew = this.rkstep54();
            }
            catch (Exception ex) {
                this.report.singularityforward = true;
                this.report.timeforward = this.t;
                break;
            }
            if (!this.stepsizecontrol || this.esterror <= this.tol) {
                accepted = true;
                if (Math.abs(this.h) < this.report.minstepsizeforward) {
                    this.report.minstepsizeforward = this.h;
                }
                if (Math.abs(this.h) > this.report.maxstepsizeforward) {
                    this.report.maxstepsizeforward = this.h;
                }
                if (this.denseoutput) {
                    double denseT = this.t + this.hdense;
                    while (denseT < this.t + this.h) {
                        this.theta = Math.abs((denseT - this.t) / this.h);
                        denseY = this.dense54();
                        if (this.t + this.h >= this.a) {
                            solforward.add(denseY);
                        }
                        denseT += this.hdense;
                    }
                }
                if (!this.onlyendsolution && this.t >= this.a) {
                    solforward.add(ynew);
                }
                this.y = ynew;
                this.t += this.h;
                if (Math.abs(this.b - this.t) <= this.hmin) break;
                this.h = Math.min(Math.abs(this.b - this.t), this.newStepSize());
            } else {
                accepted = false;
                this.h = Math.min(Math.abs(this.b - this.t), this.newStepSize());
                ++this.report.stepsrepeatedforward;
            }
            ++count;
            if (output == null) continue;
            output.out(this.y, this.esterror, this.h, accepted);
        }
        this.report.valueforward = this.y;
        this.report.stepsforward = count;
        this.y = this.initials;
        this.t = this.start;
        count = 0;
        this.h = -Math.min(this.hstart, this.t - this.a);
        this.report.timebackward = this.a;
        if (this.integrationDirection == 0 || this.integrationDirection == 2) {
            while (this.t >= this.a) {
                if (Math.abs(this.h) < this.report.minstepsizebackward) {
                    this.report.minstepsizebackward = Math.abs(this.h);
                }
                if (Math.abs(this.h) > this.report.maxstepsizebackward) {
                    this.report.maxstepsizebackward = Math.abs(this.h);
                }
                if (Math.abs(this.h) < this.hmin) {
                    this.report.toosmallstepbackward = true;
                    this.report.timebackward = this.t;
                    break;
                }
                if (count >= this.maxsteps) {
                    this.report.toomanystepsbackward = true;
                    this.report.timebackward = this.t;
                    break;
                }
                try {
                    ynew = this.rkstep54();
                }
                catch (Exception ex) {
                    this.report.singularitybackward = true;
                    this.report.timebackward = this.t;
                    break;
                }
                if (!this.stepsizecontrol || this.esterror <= this.tol) {
                    accepted = true;
                    if (this.denseoutput) {
                        double denseT = this.t - this.hdense;
                        while (denseT > this.t + this.h) {
                            this.theta = Math.abs((denseT - this.t) / Math.abs(this.h));
                            denseY = this.dense54();
                            solbackward.add(denseY);
                            denseT -= this.hdense;
                        }
                    }
                    if (!this.onlyendsolution) {
                        solbackward.add(ynew);
                    }
                    this.y = ynew;
                    this.t += this.h;
                    if (Math.abs(this.a - this.t) <= this.hmin) break;
                    this.h = -Math.min(Math.abs(this.a - this.t), this.newStepSize());
                } else {
                    accepted = false;
                    this.h = -Math.min(Math.abs(this.a - this.t), this.newStepSize());
                    ++this.report.stepsrepeatedbackward;
                }
                ++count;
                if (output == null) continue;
                output.out(this.y, this.esterror, this.h, accepted);
            }
        }
        this.report.stepsbackward = count;
        boolean bl = this.report.integratedforward ? !(this.report.toosmallstepforward || this.report.toomanystepsforward || this.report.singularityforward) : (this.report.successforward = true);
        this.report.successbackward = this.report.integratedbackward ? !(this.report.toosmallstepbackward || this.report.toomanystepsbackward || this.report.singularitybackward) : true;
        this.report.valuebackward = this.y;
        if (!this.stepsizecontrol) {
            this.report.maxstepsizebackward = this.hstart;
            this.report.minstepsizebackward = this.hstart;
            this.report.maxstepsizeforward = this.hstart;
            this.report.minstepsizeforward = this.hstart;
        }
        if (this.onlyendsolution) {
            sol.add(ynew);
        } else {
            int i = solbackward.size() - 1;
            while (i >= 0) {
                sol.add(solbackward.elementAt(i));
                --i;
            }
            if (this.a <= this.start && this.start <= this.b) {
                sol.add(this.initials);
            }
            i = 0;
            while (i < solforward.size()) {
                sol.add(solforward.elementAt(i));
                ++i;
            }
        }
        return sol;
    }

    private double[] dense54() {
        double dense0 = this.theta * (1.0 + this.theta * (-2.785416666666667 + this.theta * (2.886111111111111 + this.theta * -1.0095486111111112)));
        double dense1 = 0.0;
        double dense2 = 100.0 * this.theta * this.theta * (0.11363881401617251 + this.theta * (-0.1682659478885894 + this.theta * 0.06810422282120396)) / 3.0;
        double dense3 = -5.0 * this.theta * this.theta * (0.675 + this.theta * (-1.8 + this.theta * 0.8645833333333334)) / 2.0;
        double dense4 = 18225.0 * this.theta * this.theta * (-0.012 + this.theta * (0.058666666666666666 + this.theta * -0.06166666666666667)) / 848.0;
        double dense5 = -22.0 * this.theta * this.theta * (-0.3 + this.theta * (0.9666666666666667 + this.theta * -0.7083333333333334)) / 7.0;
        double dense6 = 0.0;
        double[] denseY = new double[this.n];
        double[] f0 = this.steps[0];
        double[] f1 = this.steps[1];
        double[] f2 = this.steps[2];
        double[] f3 = this.steps[3];
        double[] f4 = this.steps[4];
        double[] f5 = this.steps[5];
        double[] f6 = this.steps[6];
        int i = 0;
        while (i < this.n) {
            denseY[i] = this.y[i] + this.h * (dense0 * f0[i] + dense1 * f1[i] + dense2 * f2[i] + dense3 * f3[i] + dense4 * f4[i] + dense5 * f5[i] + dense6 * f6[i]);
            ++i;
        }
        return denseY;
    }

    private double[] rkstep54() throws Exception {
        double[] ytemp = new double[this.n];
        double[] ynew = new double[this.n];
        double a21 = 0.2;
        double a31 = 0.075;
        double a32 = 0.225;
        double a41 = 0.9777777777777777;
        double a42 = -3.7333333333333334;
        double a43 = 3.5555555555555554;
        double a51 = 2.9525986892242035;
        double a52 = -11.595793324188385;
        double a53 = 9.822892851699436;
        double a54 = -0.2908093278463649;
        double a61 = 2.8462752525252526;
        double a62 = -10.757575757575758;
        double a63 = 8.906422717743473;
        double a64 = 0.2784090909090909;
        double a65 = -0.2735313036020583;
        double a71 = 0.09114583333333333;
        double a72 = 0.0;
        double a73 = 0.44923629829290207;
        double a74 = 0.6510416666666666;
        double a75 = -0.322376179245283;
        double a76 = 0.13095238095238096;
        double e1 = 0.0012326388888888888;
        double e2 = 0.0;
        double e3 = -0.0042527702905061394;
        double e4 = 0.03697916666666667;
        double e5 = -0.05086379716981132;
        double e6 = 0.0419047619047619;
        double e7 = -0.025;
        double[] f1 = this.derivs(this.y);
        int i = 0;
        while (i < this.n) {
            ytemp[i] = this.y[i] + this.h * a21 * f1[i];
            ++i;
        }
        double[] f2 = this.derivs(ytemp);
        i = 0;
        while (i < this.n) {
            ytemp[i] = this.y[i] + this.h * (a31 * f1[i] + a32 * f2[i]);
            ++i;
        }
        double[] f3 = this.derivs(ytemp);
        i = 0;
        while (i < this.n) {
            ytemp[i] = this.y[i] + this.h * (a41 * f1[i] + a42 * f2[i] + a43 * f3[i]);
            ++i;
        }
        double[] f4 = this.derivs(ytemp);
        i = 0;
        while (i < this.n) {
            ytemp[i] = this.y[i] + this.h * (a51 * f1[i] + a52 * f2[i] + a53 * f3[i] + a54 * f4[i]);
            ++i;
        }
        double[] f5 = this.derivs(ytemp);
        i = 0;
        while (i < this.n) {
            ytemp[i] = this.y[i] + this.h * (a61 * f1[i] + a62 * f2[i] + a63 * f3[i] + a64 * f4[i] + a65 * f5[i]);
            ++i;
        }
        double[] f6 = this.derivs(ytemp);
        i = 0;
        while (i < this.n) {
            ytemp[i] = this.y[i] + this.h * (a71 * f1[i] + a72 * f2[i] + a73 * f3[i] + a74 * f4[i] + a75 * f5[i] + a76 * f6[i]);
            ++i;
        }
        double[] f7 = this.derivs(ytemp);
        i = 0;
        while (i < this.n) {
            if (Double.isInfinite(ytemp[i])) {
                throw new Exception(Messages.getString(BUNDLE_NAME, "ODESolver.3"));
            }
            ynew[i] = ytemp[i];
            ++i;
        }
        this.steps[0] = f1;
        this.steps[1] = f2;
        this.steps[2] = f3;
        this.steps[3] = f4;
        this.steps[4] = f5;
        this.steps[5] = f6;
        this.steps[6] = f7;
        i = 0;
        while (i < this.n) {
            this.yerr[i] = this.h * (0.0012326388888888888 * f1[i] + 0.0 * f2[i] + -0.0042527702905061394 * f3[i] + 0.03697916666666667 * f4[i] + -0.05086379716981132 * f5[i] + 0.0419047619047619 * f6[i] + -0.025 * f7[i]);
            ++i;
        }
        this.esterror = this.calcerr(this.y, ynew, this.yerr);
        return ynew;
    }

    protected double[] derivs(double[] y) throws Exception {
        return this.f.getValue(y);
    }

    public Function getDGL() {
        return this.f;
    }

    public static class ODEReport {
        public int stepsforward;
        public int stepsbackward;
        public boolean toosmallstepforward = false;
        public boolean toosmallstepbackward = false;
        public boolean toomanystepsforward = false;
        public boolean toomanystepsbackward = false;
        public boolean integratedforward = false;
        public boolean integratedbackward = false;
        public boolean singularityforward = false;
        public boolean singularitybackward = false;
        public double timeforward;
        public double timebackward;
        public int stepsrepeatedforward;
        public int stepsrepeatedbackward;
        public boolean successforward = false;
        public boolean successbackward = false;
        public double maxstepsizeforward;
        public double minstepsizeforward;
        public double maxstepsizebackward;
        public double minstepsizebackward;
        public double[] valueforward;
        public double[] valuebackward;
    }

    public static abstract class Output {
        public abstract void out(double[] var1, double var2, double var4, boolean var6);
    }
}

