/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.ToolTipable;

public class PhysicMass2D
extends Drawable2D
implements ToolTipable {
    protected double x;
    protected double y;
    protected int sizeX = 5;
    protected int sizeY = 5;
    private boolean tooltipenabled = false;
    private String toolTip = null;
    private boolean[] fixationSpots = new boolean[4];
    public static int NORTH = 0;
    public static int EAST = 1;
    public static int SOUTH = 2;
    public static int WEST = 3;

    public PhysicMass2D() {
    }

    public PhysicMass2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean[] isFixationSpotsEnable() {
        return this.fixationSpots;
    }

    public Punkt2D getFixationNorth() {
        int yp = this.scene2d.yToPixel(this.y) - this.sizeY / 2;
        return new Punkt2D(this.x, this.scene2d.pixelToY(yp));
    }

    public Punkt2D getFixationEast() {
        int xp = this.scene2d.xToPixel(this.x) + this.sizeX / 2;
        return new Punkt2D(this.scene2d.pixelToX(xp), this.y);
    }

    public Punkt2D getFixationSouth() {
        int yp = this.scene2d.yToPixel(this.y) + this.sizeY / 2;
        return new Punkt2D(this.x, this.scene2d.pixelToY(yp));
    }

    public Punkt2D getFixationWest() {
        int xp = this.scene2d.xToPixel(this.x) - this.sizeX / 2;
        return new Punkt2D(this.scene2d.pixelToX(xp), this.y);
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void enableFixationNorth(boolean b) {
        this.fixationSpots[0] = b;
    }

    public void enableFixationEast(boolean b) {
        this.fixationSpots[1] = b;
    }

    public void enableFixationSouth(boolean b) {
        this.fixationSpots[2] = b;
    }

    public void enableFixationWest(boolean b) {
        this.fixationSpots[3] = b;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setCoordinates(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int sizeX, int sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public void setToolTipText(String tooltip) {
        this.toolTip = tooltip;
    }

    public void setCoordinates(Punkt2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    public boolean isToolTipEnabled() {
        return this.tooltipenabled;
    }

    public void enableToolTip(boolean b) {
        this.tooltipenabled = b;
    }

    public void setRadius(int sizeX, int sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public boolean tooltipcontains(int xm, int ym) {
        int yp;
        int xp = this.scene2d.xToPixel(this.x);
        return (xm - xp) * (xm - xp) + (ym - (yp = this.scene2d.yToPixel(this.y))) * (ym - yp) <= this.sizeX * this.sizeY;
    }

    public Punkt2D getPunkt2D() {
        return new Punkt2D(this.x, this.y);
    }

    public String getToolTipText(MouseEvent ev) {
        if (this.toolTip == null) {
            String str = "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + ")";
            return str;
        }
        return this.toolTip;
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        int xp = this.scene2d.xToPixel(this.x);
        int yp = this.scene2d.yToPixel(this.y);
        int radius = this.sizeX / 10;
        g2.setColor(this.color);
        g2.fillRect(xp - this.sizeX / 2, yp - this.sizeY / 2, this.sizeX, this.sizeY);
        if (this.fixationSpots[0]) {
            g2.fillOval(xp - radius, yp - this.sizeY / 2 - radius, 2 * radius + 1, 2 * radius + 1);
        }
        if (this.fixationSpots[1]) {
            g2.fillOval(xp + this.sizeX / 2 - radius, yp - radius, 2 * radius + 1, 2 * radius + 1);
        }
        if (this.fixationSpots[2]) {
            g2.fillOval(xp - radius, yp + this.sizeY / 2 - radius, 2 * radius + 1, 2 * radius + 1);
        }
        if (this.fixationSpots[3]) {
            g2.fillOval(xp - this.sizeX / 2 - radius, yp - radius, 2 * radius + 1, 2 * radius + 1);
        }
    }
}

