/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import Jama.util.Maths;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.geom2d.Punkt2D;

public class PhysicFeder2D
extends Drawable2D {
    protected double x1;
    protected double x2;
    protected double y1;
    protected double y2;
    protected int sizeX;
    protected int sizeY;
    protected int sizeZ;

    public PhysicFeder2D() {
    }

    public PhysicFeder2D(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public double getX1() {
        return this.x1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY1() {
        return this.y1;
    }

    public double getY2() {
        return this.y2;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public void setX1(double x1) {
        this.x1 = x1;
    }

    public void setX2(double x2) {
        this.x2 = x2;
    }

    public void setY1(double y1) {
        this.y1 = y1;
    }

    public void setY2(double y2) {
        this.y2 = y2;
    }

    public void setCoordinates(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void setSize(int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public void setCoordinates(Punkt2D p, Punkt2D q) {
        this.x1 = p.x;
        this.y1 = p.y;
        this.x2 = q.x;
        this.y2 = q.y;
    }

    public Punkt2D getAPunkt2D() {
        return new Punkt2D(this.x1, this.y1);
    }

    public Punkt2D getEPunkt2D() {
        return new Punkt2D(this.x2, this.y2);
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        double yPixelScale = this.scene2d.getYPixelScale();
        double breite = (double)this.sizeX * yPixelScale;
        int dicke = this.sizeY;
        g2.setColor(this.color);
        g2.setStroke(new BasicStroke(dicke >= 0 ? dicke : -dicke));
        if (!(this.x1 == this.x2 & this.y1 == this.y2)) {
            double xli = (this.x2 - this.x1) / (double)(2 * this.sizeZ + 1);
            double yli = (this.y2 - this.y1) / (double)(2 * this.sizeZ + 1);
            double xs = breite * -yli / Maths.hypot(xli, yli);
            double ys = breite * xli / Maths.hypot(xli, yli);
            int xp1 = this.scene2d.xToPixel(this.x1);
            int yp1 = this.scene2d.yToPixel(this.y1);
            int xp2 = this.scene2d.xToPixel(this.x1 + xs + xli);
            int yp2 = this.scene2d.yToPixel(this.y1 + ys + yli);
            g2.drawLine(xp1, yp1, xp2, yp2);
            int i = 1;
            while (i < 2 * this.sizeZ) {
                double vor1 = Math.pow(-1.0, i + 1);
                double vor2 = Math.pow(-1.0, i);
                xp1 = this.scene2d.xToPixel(this.x1 + vor1 * xs + xli * (double)i);
                yp1 = this.scene2d.yToPixel(this.y1 + vor1 * ys + yli * (double)i);
                xp2 = this.scene2d.xToPixel(this.x1 + vor2 * xs + xli * (double)(i + 1));
                yp2 = this.scene2d.yToPixel(this.y1 + vor2 * ys + yli * (double)(i + 1));
                g2.drawLine(xp1, yp1, xp2, yp2);
                ++i;
            }
            xp1 = this.scene2d.xToPixel(this.x1 - xs + (double)(2 * this.sizeZ) * xli);
            yp1 = this.scene2d.yToPixel(this.y1 - ys + (double)(2 * this.sizeZ) * yli);
            xp2 = this.scene2d.xToPixel(this.x2);
            yp2 = this.scene2d.yToPixel(this.y2);
            g2.drawLine(xp1, yp1, xp2, yp2);
        }
    }
}

