/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.schwingung;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import uibk.applets.schwingung.AppletSchwingung;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.RepaintThread;
import uibk.mtk.math.Rounder;
import uibk.mtk.swing.base.Button;
import uibk.mtk.swing.base.ButtonNoFocus;
import uibk.mtk.swing.base.MPanel;

public class PanelSkale
extends MPanel
implements ActionListener {
    public final AppletSchwingung main;
    private final MathPanel2D mathPanel2D = new MathPanel2D();
    private MathPanel2D mathPanel2dGraph;
    private Axes2D axes;
    private static final int SIZEX = 150;
    private static final int SIZEY = 130;
    private MathPoint2D point;
    private ButtonNoFocus buttonBothZoomIn;
    private ButtonNoFocus buttonBothZoomOut;
    private static final double SCALEFAKTOR = 1.3;
    private boolean scaleXY = true;
    private Button buttonNull;
    private Graph2D[] graph;
    protected double yMin;
    protected double yMax;

    public PanelSkale(AppletSchwingung main, MathPanel2D mathPanel2D, RepaintThread repaintThread) {
        this.main = main;
        this.mathPanel2dGraph = mathPanel2D;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanelCenter(), "West");
        this.add((Component)this.createPanelOption(), "Center");
        this.yMin = this.mathPanel2dGraph.getScene2d().getYmin();
        this.yMax = this.mathPanel2dGraph.getScene2d().getYmax();
    }

    private MPanel createPanelCenter() {
        MPanel panelCenter = new MPanel();
        panelCenter.setLayout(new BorderLayout());
        panelCenter.setMaximumSize(new Dimension(150, 130));
        panelCenter.setPreferredSize(new Dimension(150, 130));
        panelCenter.setMinimumSize(new Dimension(150, 130));
        TitledBorder b = BorderFactory.createTitledBorder(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.1"));
        b.setTitleFont(b.getTitleFont().deriveFont(1));
        panelCenter.setBorder(b);
        this.point = new MathPoint2D();
        this.point.setColor(Color.red);
        this.point.setVisible(true);
        this.point.setRadius(5);
        this.mathPanel2D.add(this.point);
        this.axes = new Axes2D();
        this.axes.setVisible(true);
        this.axes.setColor(Color.black);
        this.axes.setStyleXAxis(2);
        this.axes.setStyleYAxis(2);
        this.mathPanel2D.add(this.axes);
        this.mathPanel2D.getScene2d().enableRoundX(false);
        this.mathPanel2D.getScene2d().enableRoundY(false);
        this.mathPanel2D.getScene2d().setEdge(0);
        this.mathPanel2D.addMouseListener(new MyMouseListener());
        this.mathPanel2D.addMouseMotionListener(new MyMouseMotionListener());
        this.mathPanel2D.setToolTipText(Messages.getString("uibk.applets.schwingung.messages", "PanelZomm.7"));
        panelCenter.add((Component)this.mathPanel2D, "Center");
        return panelCenter;
    }

    private MPanel createPanelOption() {
        MPanel panelOption = new MPanel();
        panelOption.setLayout(new BorderLayout());
        panelOption.add((Component)this.createPaneOptions(), "North");
        panelOption.add((Component)this.createPanelSkale(), "Center");
        return panelOption;
    }

    private MPanel createPanelSkale() {
        MPanel panelSkale = new MPanel();
        TitledBorder b = BorderFactory.createTitledBorder(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.2"));
        b.setTitleFont(b.getTitleFont().deriveFont(1));
        panelSkale.setBorder(b);
        Border emptyB = BorderFactory.createEmptyBorder(0, 0, 5, 5);
        URL urlIconPlus = this.getClass().getResource("/uibk/mtk/swing/res/plus.gif");
        URL urlIconMinus = this.getClass().getResource("/uibk/mtk/swing/res/minus.gif");
        this.buttonBothZoomIn = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.buttonBothZoomIn.setActionCommand("bothzoomin");
        this.buttonBothZoomIn.addActionListener(this);
        this.buttonBothZoomIn.setBorder(emptyB);
        this.buttonBothZoomOut = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.buttonBothZoomOut.setActionCommand("bothzoomout");
        this.buttonBothZoomOut.addActionListener(this);
        this.buttonBothZoomOut.setBorder(emptyB);
        this.buttonBothZoomIn.setEnabled(false);
        this.buttonBothZoomOut.setEnabled(false);
        panelSkale.add(this.buttonBothZoomIn);
        panelSkale.add(this.buttonBothZoomOut);
        return panelSkale;
    }

    private MPanel createPaneOptions() {
        MPanel panelSetCenter = new MPanel();
        panelSetCenter.setLayout(new BorderLayout());
        panelSetCenter.setBorder(BorderFactory.createEmptyBorder(4, 4, 10, 4));
        this.buttonNull = new Button(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.3"));
        this.buttonNull.setActionCommand("setCenter");
        this.buttonNull.addActionListener(this);
        Button buttonLoeschen = new Button(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.10"));
        buttonLoeschen.setActionCommand("loeschen");
        buttonLoeschen.addActionListener(this);
        Button buttonAll = new Button(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.11"));
        buttonAll.setActionCommand("all");
        buttonAll.addActionListener(this);
        panelSetCenter.add((Component)buttonLoeschen, "North");
        panelSetCenter.add((Component)this.buttonNull, "Center");
        panelSetCenter.add((Component)buttonAll, "South");
        return panelSetCenter;
    }

    public void actionPerformed(ActionEvent ev) {
        long time = System.currentTimeMillis();
        while (!this.main.diagramm.isReady) {
            if (System.currentTimeMillis() - time <= 5000L) continue;
            return;
        }
        this.main.diagramm.isReady = false;
        if (ev.getActionCommand().equals("all")) {
            this.autoskale();
        }
        Scene2D scene2dGraph = this.mathPanel2dGraph.getScene2d();
        Scene2D scene2d = this.mathPanel2D.getScene2d();
        double xRange = scene2dGraph.getCoordinates().getXRange() / 2.0;
        double yRange = (this.yMax - this.yMin) / 2.0;
        double x = scene2d.getXmin() + xRange;
        double y = scene2d.getYmin() + yRange;
        if (ev.getActionCommand().equals("bothzoomout")) {
            yRange *= 1.3;
            if (this.scaleXY) {
                xRange *= 1.3;
            }
            this.main.mathpanel2D.report(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.6"));
        }
        if (ev.getActionCommand().equals("bothzoomin")) {
            yRange *= 0.7692307692307692;
            if (this.scaleXY) {
                xRange *= 0.7692307692307692;
            }
            this.main.mathpanel2D.report(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.5"));
        }
        if (ev.getActionCommand().equals("setCenter")) {
            x = 0.0;
            y = 0.0;
            this.report(String.valueOf(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.1")) + ": ", x, y);
            this.main.mathpanel2D.report(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.3"));
        }
        if (this.scaleXY) {
            this.neuZeichnen(x - xRange, x + xRange, y - yRange, y + yRange);
        } else {
            this.neuZeichnen(scene2dGraph.getXmin(), scene2dGraph.getXmax(), -yRange, yRange);
        }
        if (ev.getActionCommand().equals("loeschen")) {
            this.loeschen();
        }
        this.main.diagramm.isReady = true;
    }

    private void loeschen() {
        this.main.diagramm.clear();
        this.main.mathpanel2D.report(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.4"));
    }

    private void autoskale() {
        if (this.graph != null && this.graph[0].getNumberPoints() > 2) {
            CoordinateRect2D limitsC = this.graph[0].getLimits();
            int i = 1;
            while (i < this.graph.length) {
                CoordinateRect2D tmplimits = this.graph[i].getLimits();
                if (tmplimits.xmin < limitsC.xmin) {
                    limitsC.xmin = tmplimits.xmin;
                }
                if (tmplimits.xmax > limitsC.xmax) {
                    limitsC.xmax = tmplimits.xmax;
                }
                if (tmplimits.ymin < limitsC.ymin) {
                    limitsC.ymin = tmplimits.ymin;
                }
                if (tmplimits.ymax > limitsC.ymax) {
                    limitsC.ymax = tmplimits.ymax;
                }
                ++i;
            }
            if (this.scaleXY) {
                if (limitsC.getXRange() > limitsC.getYRange()) {
                    this.yMin = limitsC.ymin;
                    this.yMax = this.yMin + limitsC.getXRange();
                } else {
                    this.yMin = limitsC.ymin;
                    this.yMax = this.yMin + limitsC.getYRange();
                    limitsC.xmax = limitsC.xmin + limitsC.getYRange();
                }
                this.mathPanel2dGraph.getScene2d().setLimits(limitsC.xmin, limitsC.xmax, this.yMin, this.yMax);
                this.copyCoordinates();
            } else if (Math.abs(limitsC.ymax) > Math.abs(limitsC.ymin)) {
                this.yMax = limitsC.ymax;
                this.yMin = -limitsC.ymax;
            } else {
                this.yMax = -limitsC.ymin;
                this.yMin = limitsC.ymin;
            }
            this.main.mathpanel2D.report(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.7"));
        }
    }

    private void neuZeichnen(double xmin, double xmax, double ymin, double ymax) {
        this.mathPanel2dGraph.getScene2d().setLimits(xmin, xmax, ymin, ymax);
        this.yMin = this.mathPanel2dGraph.getScene2d().getYmin();
        this.yMax = this.mathPanel2dGraph.getScene2d().getYmax();
        this.mathPanel2dGraph.requestRecompute(true);
        this.copyCoordinates();
    }

    public void copyCoordinates() {
        Scene2D scene2dGraph = this.mathPanel2dGraph.getScene2d();
        Scene2D scene2d = this.mathPanel2D.getScene2d();
        scene2d.setLimits(scene2dGraph.getCoordinates());
        this.point.setX(scene2dGraph.getXmin() + scene2dGraph.getXRange() / 2.0);
        this.point.setY(scene2dGraph.getYmin() + scene2dGraph.getYRange() / 2.0);
        this.mathPanel2D.repaint();
    }

    public void setEnabledXY(boolean enabled) {
        this.axes.setVisible(true);
        this.buttonNull.setEnabled(enabled);
        this.mathPanel2D.setVisible(enabled);
        this.scaleXY = enabled;
        this.yMin = this.mathPanel2dGraph.getScene2d().getYmin();
        this.yMax = this.mathPanel2dGraph.getScene2d().getYmax();
        this.buttonBothZoomIn.setEnabled(true);
        this.buttonBothZoomOut.setEnabled(true);
    }

    private void report(String text, double x, double y) {
        x = Rounder.roundNumPlaces(x, 1);
        y = Rounder.roundNumPlaces(y, 1);
        this.main.mathpanel2D.report(String.valueOf(text) + "(x,y)=( " + x + " , " + y + " )");
    }

    public void setGraph(Graph2D[] graph) {
        this.graph = graph;
    }

    private class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mouseClicked(MouseEvent ev) {
            if (!PanelSkale.this.isEnabled()) {
                return;
            }
            Scene2D scene2dGraph = PanelSkale.this.mathPanel2dGraph.getScene2d();
            Scene2D scene2d = PanelSkale.this.mathPanel2D.getScene2d();
            double xRange = scene2dGraph.getCoordinates().getXRange() / 2.0;
            double yRange = scene2dGraph.getCoordinates().getYRange() / 2.0;
            double x = scene2d.pixelToX(ev.getX());
            double y = scene2d.pixelToY(ev.getY());
            PanelSkale.this.point.setVisible(true);
            PanelSkale.this.point.setX(x);
            PanelSkale.this.point.setY(y);
            PanelSkale.this.neuZeichnen(x - xRange, x + xRange, y - yRange, y + yRange);
            PanelSkale.this.report(String.valueOf(Messages.getString("uibk.applets.schwingung.messages", "PanelZoom.1")) + ": ", x, y);
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        MyMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent ev) {
            if (!PanelSkale.this.isEnabled()) {
                return;
            }
            Scene2D scene2d = PanelSkale.this.mathPanel2D.getScene2d();
            double x = scene2d.pixelToX(ev.getX());
            double y = scene2d.pixelToY(ev.getY());
            PanelSkale.this.report("", x, y);
        }
    }
}

