/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.schwingung;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.schwingung.AppletSchwingung;
import uibk.applets.schwingung.PanelSkale;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.RepaintThread;
import uibk.mtk.swing.base.MPanel;

public class PanelDiagramm {
    public boolean isReady = true;
    private RepaintThread repaintThread;
    private final AppletSchwingung main;
    public MathPanel2D mathPanel2D = new MathPanel2D();
    private Axes2D axes = new Axes2D();
    public Graph2D[] graph = null;
    public boolean X_V = false;
    public boolean X_A = false;
    public boolean V_A = false;
    public boolean X_T = false;
    public boolean V_T = false;
    public boolean A_T = false;
    private JSlider slider;
    private PanelSkale panelSkale;
    private static final int INTERVALL = 60;
    public int konfig = 1;

    public PanelDiagramm(AppletSchwingung main) {
        this.main = main;
        this.repaintThread = new RepaintThread(this.mathPanel2D);
        this.panelSkale = new PanelSkale(main, this.mathPanel2D, this.repaintThread);
        this.axes.setVisible(false);
        this.mathPanel2D.add(main.axes);
        this.mathPanel2D.getScene2d().enableRoundX(false);
        this.mathPanel2D.getScene2d().enableRoundY(false);
        this.mathPanel2D.setDoubleBuffered(true);
    }

    public void addPunkt(double t, double x, double v, double a, int i) {
        if (this.X_V) {
            this.graph[i].addPoint(new Punkt2D(x, v));
        } else if (this.X_A) {
            this.graph[i].addPoint(new Punkt2D(x, a));
        } else if (this.V_A) {
            this.graph[i].addPoint(new Punkt2D(v, a));
        } else if (this.X_T || this.V_T || this.A_T) {
            Punkt2D p = new Punkt2D(t, 0.0);
            this.mathPanel2D.requestRecompute(true);
            if (this.X_T) {
                p.y = x;
            }
            if (this.V_T) {
                p.y = v;
            }
            if (this.A_T) {
                p.y = a;
            }
            this.graph[i].addPoint(p);
            if (this.graph[i].getFirstPoint() != null) {
                if (t - this.graph[i].getFirstPoint().x > 60.0) {
                    while (t - 60.0 > this.graph[i].getFirstPoint().x) {
                        this.graph[i].clearFirstPoint();
                    }
                    this.mathPanel2D.getScene2d().setLimits(this.graph[i].getFirstPoint().x, t, this.panelSkale.yMin, this.panelSkale.yMax);
                } else {
                    this.mathPanel2D.getScene2d().setLimits(t - 60.0, t, this.panelSkale.yMin, this.panelSkale.yMax);
                }
            }
        }
    }

    public void neu(int Anz) {
        this.axes.setVisible(true);
        this.repaintThread = new RepaintThread(this.mathPanel2D);
        if (this.graph != null) {
            int i = 0;
            while (i < this.graph.length) {
                this.mathPanel2D.delete(this.graph[i]);
                ++i;
            }
        }
        this.graph = new Graph2D[Anz];
        Color[] color = new Color[]{Color.GREEN, Color.RED, Color.BLUE};
        int i = 0;
        while (i < Anz) {
            this.graph[i] = new Graph2D();
            this.graph[i].clearpoints();
            this.graph[i].setVisible(true);
            this.graph[i].setColor(color[i]);
            this.mathPanel2D.add(this.graph[i]);
            this.repaintThread.addGraph(this.graph[i]);
            ++i;
        }
        this.panelSkale.setGraph(this.graph);
        this.slider.setEnabled(true);
        int n = this.slider.getValue();
        this.main.schwingung.setAufloesung((double)n / 100.0);
        this.mathPanel2D.repaint();
        if (this.X_V) {
            this.x_v();
        }
        if (this.X_A) {
            this.x_a();
        }
        if (this.V_A) {
            this.v_a();
        }
        if (this.X_T) {
            this.x_t();
        }
        if (this.V_T) {
            this.v_t();
        }
        if (this.A_T) {
            this.a_t();
        }
    }

    public MPanel createPanelOption() {
        MPanel panelOption = new MPanel();
        panelOption.setLayout(new BorderLayout());
        this.panelSkale.setEnabledXY(false);
        panelOption.add((Component)this.createPanelAufloes(), "North");
        panelOption.add((Component)this.panelSkale, "South");
        return panelOption;
    }

    public MPanel createPanelAufloes() {
        MPanel panelButtons = new MPanel();
        panelButtons.setLayout(new GridLayout(0, 1, 30, 5));
        panelButtons.setMaximumSize(new Dimension(2000, 100));
        panelButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 15, 5));
        this.slider = new JSlider();
        this.slider.setMinimum(1);
        this.slider.setValue(10);
        this.slider.setMaximum(20);
        this.slider.setEnabled(false);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                if (((PanelDiagramm)PanelDiagramm.this).main.schwingung != null) {
                    ((PanelDiagramm)PanelDiagramm.this).main.schwingung.setAufloesung((double)n / 100.0);
                }
            }
        });
        JLabel label = new JLabel(Messages.getString("uibk.applets.schwingung.messages", "PanelDiagramm.11"));
        panelButtons.add(label);
        panelButtons.add(this.slider);
        return panelButtons;
    }

    public void clear() {
        if (this.graph != null) {
            int i = 0;
            while (i < this.graph.length) {
                this.graph[i].clearpoints();
                ++i;
            }
        }
        this.mathPanel2D.requestRecompute(true);
    }

    public void x_v() {
        this.X_V = true;
        this.X_A = false;
        this.V_A = false;
        this.X_T = false;
        this.V_T = false;
        this.A_T = false;
        this.axes.setCaptionXAxis("x");
        this.axes.setCaptionYAxis("v");
        this.mathPanel2D.getScene2d().axesequal(true);
        this.mathPanel2D.getScene2d().setLimits(Math.PI * -2, Math.PI * 2, Math.PI * -2, Math.PI * 2);
        this.clear();
        this.panelSkale.setEnabledXY(true);
        this.panelSkale.copyCoordinates();
        this.mathPanel2D.requestRecompute(true);
    }

    public void x_a() {
        this.X_V = false;
        this.X_A = true;
        this.V_A = false;
        this.X_T = false;
        this.V_T = false;
        this.A_T = false;
        this.axes.setCaptionXAxis("\u03c6(t)");
        this.axes.setCaptionYAxis("\u03c6''(t)");
        this.mathPanel2D.getScene2d().axesequal(true);
        this.mathPanel2D.getScene2d().setLimits(Math.PI * -2, Math.PI * 2, Math.PI * -2, Math.PI * 2);
        this.clear();
        this.panelSkale.setEnabledXY(true);
        this.panelSkale.copyCoordinates();
        this.mathPanel2D.requestRecompute(true);
    }

    public void v_a() {
        this.X_V = false;
        this.X_A = false;
        this.V_A = true;
        this.X_T = false;
        this.V_T = false;
        this.A_T = false;
        this.axes.setCaptionXAxis("\u03c6'(t)");
        this.axes.setCaptionYAxis("\u03c6''(t)");
        this.mathPanel2D.getScene2d().axesequal(true);
        this.mathPanel2D.getScene2d().setLimits(Math.PI * -2, Math.PI * 2, Math.PI * -2, Math.PI * 2);
        this.clear();
        this.panelSkale.setEnabledXY(true);
        this.panelSkale.copyCoordinates();
        this.mathPanel2D.requestRecompute(true);
    }

    public void x_t() {
        while (!this.isReady) {
        }
        this.isReady = false;
        this.X_V = false;
        this.X_A = false;
        this.V_A = false;
        this.X_T = true;
        this.V_T = false;
        this.A_T = false;
        this.axes.setCaptionXAxis("t");
        this.axes.setCaptionYAxis("\u03c6(t)");
        this.mathPanel2D.getScene2d().axesequal(false);
        if (this.graph != null && this.graph[0] != null && this.graph[0].getLastPoint() != null) {
            double t = this.graph[0].getLastPoint().x;
            this.mathPanel2D.getScene2d().setLimits(t - 60.0, t, Math.PI * -2, Math.PI * 2);
        } else {
            this.mathPanel2D.getScene2d().setLimits(0.0, 80.0, Math.PI * -2, Math.PI * 2);
        }
        this.clear();
        this.panelSkale.setEnabledXY(false);
        this.mathPanel2D.requestRecompute(true);
        this.isReady = true;
    }

    public void v_t() {
        while (!this.isReady) {
        }
        this.isReady = false;
        this.X_V = false;
        this.X_A = false;
        this.V_A = false;
        this.X_T = false;
        this.V_T = true;
        this.A_T = false;
        this.axes.setCaptionXAxis("t");
        this.axes.setCaptionYAxis("\u03c6'(t)");
        this.mathPanel2D.getScene2d().axesequal(false);
        if (this.graph != null && this.graph[0] != null && this.graph[0].getLastPoint() != null) {
            double t = this.graph[0].getLastPoint().x;
            this.mathPanel2D.getScene2d().setLimits(t - 60.0, t, Math.PI * -2, Math.PI * 2);
        } else {
            this.mathPanel2D.getScene2d().setLimits(0.0, 80.0, Math.PI * -2, Math.PI * 2);
        }
        this.clear();
        this.panelSkale.setEnabledXY(false);
        this.mathPanel2D.requestRecompute(true);
        this.isReady = true;
    }

    public void a_t() {
        while (!this.isReady) {
        }
        this.isReady = false;
        this.X_V = false;
        this.X_A = false;
        this.V_A = false;
        this.X_T = false;
        this.V_T = false;
        this.A_T = true;
        this.axes.setCaptionXAxis("t");
        this.axes.setCaptionYAxis("\u03c6''(t)");
        this.mathPanel2D.getScene2d().axesequal(false);
        if (this.graph != null && this.graph[0] != null && this.graph[0].getLastPoint() != null) {
            double t = this.graph[0].getLastPoint().x;
            this.mathPanel2D.getScene2d().setLimits(t - 60.0, t, Math.PI * -2, Math.PI * 2);
        } else {
            this.mathPanel2D.getScene2d().setLimits(0.0, 80.0, Math.PI * -2, Math.PI * 2);
        }
        this.clear();
        this.panelSkale.setEnabledXY(false);
        this.mathPanel2D.requestRecompute(true);
        this.isReady = true;
    }

    public void start() {
        this.repaintThread.start();
        this.mathPanel2D.setAutoRepaint(false);
        this.mathPanel2D.requestRecompute(true);
    }

    public void stop() {
        this.repaintThread.stop();
        while (!this.repaintThread.isStop()) {
            this.repaintThread.stop();
        }
        this.mathPanel2D.setAutoRepaint(true);
    }

    public void setDelay(int delay) {
        this.repaintThread.setDelay(delay);
    }
}

